/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.recipeviewer.category;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.Direction;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import snownee.lychee.client.gui.GuiGameElement;
import snownee.lychee.client.gui.InteractiveRenderElement;
import snownee.lychee.client.gui.RenderElement;
import snownee.lychee.client.gui.ScreenElement;
import snownee.lychee.compat.recipeviewer.RVs;
import snownee.lychee.compat.recipeviewer.RvHelper;
import snownee.lychee.compat.recipeviewer.category.DecorationMapBuilder;
import snownee.lychee.compat.recipeviewer.category.RvCategory;
import snownee.lychee.compat.recipeviewer.category.RvCategoryLayoutBuilder;
import snownee.lychee.compat.recipeviewer.element.ShadowElement;
import snownee.lychee.recipes.DripstoneRecipe;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.VectorExtensions;
import snownee.lychee.util.predicates.BlockPredicateExtensions;

public class DripstoneRecipeCategory
extends RvCategory<DripstoneRecipe> {
    private static final int BLOCK_SIZE = 12;
    private static final int COLUMN_X = 16;
    private static final Vector2fc SOURCE_BLOCK_POSITION = new Vector2f(16.0f, 4.0f);
    private static final Vector2fc DRIPSTONE_POSITION = VectorExtensions.offsetY(SOURCE_BLOCK_POSITION, 12.0f);
    private static final Vector2fc POINTED_DRIPSTONE_POSITION = VectorExtensions.offsetY(SOURCE_BLOCK_POSITION, 24.0f);
    public static final Vector2fc INFO_POSITION = VectorExtensions.offsetX(POINTED_DRIPSTONE_POSITION, 12.0f);
    private static final Vector2fc TARGET_BLOCK_POSITION = VectorExtensions.offsetY(SOURCE_BLOCK_POSITION, 36.0f);
    private final ShadowElement shadowElement = new ShadowElement(12, 24, 8);

    private BlockState getSourceBlock(DripstoneRecipe recipe) {
        return CommonProxy.getCycledItem(BlockPredicateExtensions.getShowcaseBlockStates(recipe.sourceBlock()), Blocks.AIR.defaultBlockState(), 2000);
    }

    private BlockState getTargetBlock(DripstoneRecipe recipe) {
        return CommonProxy.getCycledItem(BlockPredicateExtensions.getShowcaseBlockStates(recipe.blockPredicate()), Blocks.AIR.defaultBlockState(), 2000);
    }

    @Override
    public Vector2fc infoPosition(DripstoneRecipe recipe) {
        return INFO_POSITION;
    }

    @Override
    public void configureLayout(RvCategoryLayoutBuilder<DripstoneRecipe> builder, RecipeHolder<DripstoneRecipe> recipeHolder) {
        DripstoneRecipe recipe = (DripstoneRecipe)recipeHolder.value();
        boolean needSecondLine = recipe.conditions().showingCount() > 9;
        int y = needSecondLine ? 26 : 28;
        builder.actionGroup(recipe, (Vector2fc)new Vector2f((float)(builder.width() - 29), (float)y));
    }

    @Override
    public void setupDecorations(DecorationMapBuilder<DripstoneRecipe> mapBuilder) {
        mapBuilder.info(this::infoPosition);
        mapBuilder.consumeBlockInput($ -> VectorExtensions.offset(TARGET_BLOCK_POSITION, 8.0f, 4.0f));
        mapBuilder.put("source_block", (builder, recipeHolder) -> {
            DripstoneRecipe recipe = (DripstoneRecipe)recipeHolder.value();
            builder.addElement((RenderElement)((RenderElement)this.getBlockElement(() -> this.getSourceBlock(recipe), recipe.sourceBlock(), builder.helper()).at(SOURCE_BLOCK_POSITION)).withSize(12));
        });
        mapBuilder.put("dripstone_block", (builder, recipeHolder) -> {
            builder.addElement((RenderElement)((RenderElement)this.getBlockElement(() -> ((Block)Blocks.DRIPSTONE_BLOCK).defaultBlockState(), BlockPredicateExtensions.ANY, builder.helper()).at(DRIPSTONE_POSITION)).withSize(12));
            BlockState blockState = (BlockState)Blocks.POINTED_DRIPSTONE.defaultBlockState().setValue((Property)PointedDripstoneBlock.TIP_DIRECTION, (Comparable)Direction.DOWN);
            builder.addElement((RenderElement)((RenderElement)this.getBlockElement(() -> blockState, BlockPredicateExtensions.ANY, builder.helper()).at(POINTED_DRIPSTONE_POSITION)).withSize(12));
        });
        mapBuilder.put("target_block", (builder, recipeHolder) -> builder.addElement(this.getTargetBlockElement((DripstoneRecipe)recipeHolder.value(), builder.helper())));
    }

    protected RenderElement getBlockElement(Supplier<BlockState> stateSupplier, BlockPredicate predicate, RvHelper helper) {
        Supplier<RenderElement> blockElement = () -> GuiGameElement.of((BlockState)stateSupplier.get()).scale(12.0).lighting(RVs.BLOCK_LIGHTING).rotateBlock(12.5, -22.5, 0.0);
        return new InteractiveRenderElement(element -> (ScreenElement)blockElement.get()).onTooltip(() -> BlockPredicateExtensions.getTooltips((BlockState)stateSupplier.get(), predicate, helper)).onInput(helper.inputOnBlock(stateSupplier)).withSize(12);
    }

    protected RenderElement getTargetBlockElement(DripstoneRecipe recipe, RvHelper helper) {
        Function<BlockState, RenderElement> blockElement = blockState -> GuiGameElement.of(blockState).rotateBlock(12.5, -22.5, 0.0).scale(12.0).lighting(RVs.BLOCK_LIGHTING).withSize(12);
        InteractiveRenderElement result = this.shadowElement.blockWithShadow(() -> this.getTargetBlock(recipe), blockElement);
        return ((RenderElement)result.onTooltip(() -> BlockPredicateExtensions.getTooltips(this.getTargetBlock(recipe), recipe.blockPredicate(), helper)).onInput(helper.inputOnBlock(() -> this.getTargetBlock(recipe))).at(TARGET_BLOCK_POSITION)).withSize(12);
    }
}

