/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.recipeviewer.category;

import java.util.function.Function;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import snownee.lychee.client.gui.AllGuiTextures;
import snownee.lychee.client.gui.GuiGameElement;
import snownee.lychee.client.gui.InteractiveRenderElement;
import snownee.lychee.client.gui.RenderElement;
import snownee.lychee.compat.recipeviewer.RVs;
import snownee.lychee.compat.recipeviewer.RvHelper;
import snownee.lychee.compat.recipeviewer.category.DecorationMapBuilder;
import snownee.lychee.compat.recipeviewer.category.RvCategory;
import snownee.lychee.compat.recipeviewer.category.RvCategoryLayoutBuilder;
import snownee.lychee.compat.recipeviewer.element.ShadowElement;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.VectorExtensions;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.BlockKeyableRecipe;
import snownee.lychee.util.recipe.ILycheeRecipe;

public class ItemAndBlockCategory<R extends ILycheeRecipe<LycheeContext>>
extends RvCategory<R> {
    public static final Vector2fc INPUT_BLOCK_POSITION = new Vector2f(22.0f, 32.0f);
    public static final Vector2fc METHOD_POSITION = new Vector2f(INPUT_BLOCK_POSITION.x() - 4.0f, 10.0f);
    public static final float INPUT_INGREDIENT_X = 12.0f;
    public static final int BLOCK_SIZE = 14;
    public static final int METHOD_SIZE = 20;
    public static final Vector2fc INFO_POSITION = VectorExtensions.offset(METHOD_POSITION, 20.0f, 4.0f);
    private final ShadowElement shadowElement = new ShadowElement(14, 36, 9);

    public Vector2fc inputBlockPosition() {
        return INPUT_BLOCK_POSITION;
    }

    @Override
    public Vector2fc infoPosition(R recipe) {
        return INFO_POSITION;
    }

    public Vector2fc methodPosition() {
        return METHOD_POSITION;
    }

    public float inputIngredientX() {
        return 12.0f;
    }

    @Override
    public void configureLayout(RvCategoryLayoutBuilder<R> builder, RecipeHolder<R> recipeHolder) {
        ILycheeRecipe recipe = (ILycheeRecipe)recipeHolder.value();
        builder.ingredientGroup(recipe, (Vector2fc)new Vector2f(this.inputIngredientX(), 28.0f));
        builder.actionGroup(recipe, (Vector2fc)new Vector2f((float)(builder.width() - 29), 28.0f));
    }

    @Override
    public void setupDecorations(DecorationMapBuilder<R> mapBuilder) {
        mapBuilder.info(this::infoPosition);
        mapBuilder.consumeBlockInput($ -> VectorExtensions.offset(this.inputBlockPosition(), 10.0f, 6.0f));
        mapBuilder.put("block_in", (builder, recipeHolder) -> {
            ILycheeRecipe recipe = (ILycheeRecipe)recipeHolder.value();
            RvHelper helper = builder.helper();
            InteractiveRenderElement element = this.getInputBlockElement(recipe, this.inputBlockPosition(), helper);
            if (this.shouldRenderInputBlockTooltip(recipe)) {
                element.onTooltip(() -> BlockPredicateExtensions.getTooltips(this.getRenderingBlock(recipe), ((BlockKeyableRecipe)recipe).blockPredicate(), helper));
            }
            builder.addElement(element);
        });
        mapBuilder.put("method", (builder, recipeHolder) -> builder.addElement((RenderElement)((RenderElement)RenderElement.create(AllGuiTextures.DOWN_ARROW).at(this.methodPosition())).withSize(20)));
    }

    protected BlockState getRenderingBlock(R recipe) {
        return CommonProxy.getCycledItem(BlockPredicateExtensions.getShowcaseBlockStates(((BlockKeyableRecipe)recipe).blockPredicate()), Blocks.AIR.defaultBlockState(), 1000);
    }

    protected boolean shouldRenderInputBlockTooltip(R recipe) {
        return true;
    }

    protected InteractiveRenderElement getInputBlockElement(R recipe, Vector2fc inputBlockPosition, RvHelper helper) {
        Function<BlockState, RenderElement> blockElement = blockState -> GuiGameElement.of(blockState).rotateBlock(12.5, 160.0, 0.0).scale(15.0).lighting(RVs.BLOCK_LIGHTING).withSize(14);
        InteractiveRenderElement result = this.shadowElement.blockWithShadow(() -> this.getRenderingBlock(recipe), blockElement);
        if (this.shouldRenderInputBlockTooltip(recipe)) {
            result.onTooltip(() -> BlockPredicateExtensions.getTooltips(this.getRenderingBlock(recipe), ((BlockKeyableRecipe)recipe).blockPredicate(), helper));
        }
        return (InteractiveRenderElement)((RenderElement)result.onInput(helper.inputOnBlock(() -> this.getRenderingBlock(recipe))).at(inputBlockPosition)).withSize(14);
    }
}

