/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.recipeviewer.category;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import snownee.lychee.Lychee;
import snownee.lychee.action.PlaceBlock;
import snownee.lychee.client.gui.AllGuiTextures;
import snownee.lychee.client.gui.InteractiveRenderElement;
import snownee.lychee.client.gui.RenderElement;
import snownee.lychee.compat.recipeviewer.RVs;
import snownee.lychee.compat.recipeviewer.category.DecorationMapBuilder;
import snownee.lychee.compat.recipeviewer.category.RvCategoryDecoration;
import snownee.lychee.compat.recipeviewer.category.RvCategoryInstance;
import snownee.lychee.compat.recipeviewer.category.RvCategoryLayoutBuilder;
import snownee.lychee.ui.SpriteElementRenderer;
import snownee.lychee.util.ClientProxy;
import snownee.lychee.util.VectorExtensions;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.recipe.ILycheeRecipe;

public class RvCategory<R extends ILycheeRecipe<LycheeContext>> {
    public static final int WIDTH = 120;
    public static final int WIDER_WIDTH = 170;
    public static final int HEIGHT = 60;
    public ResourceLocation id;
    public int width = 120;
    public int height = 60;
    public IconProvider<R> iconProvider;
    public WorkstationProvider<R> workstationProvider = category -> List.of();
    public ImmutableMap<String, RvCategoryDecoration<R>> decorations = ImmutableMap.of();
    public ImmutableMap<String, Predicate<R>> conditions = ImmutableMap.of();

    public void setSimpleWorkstationProvider(Function<RvCategoryInstance<R>, List<ItemStack>> workstationProvider) {
        this.workstationProvider = category -> Lists.transform((List)((List)workstationProvider.apply(category)), xva$0 -> Ingredient.of((ItemStack[])new ItemStack[]{xva$0}));
    }

    public void init() {
        final ImmutableMap.Builder decorations = ImmutableMap.builder();
        final ImmutableMap.Builder conditions = ImmutableMap.builder();
        final LinkedHashMap lowPriorityDecorations = Maps.newLinkedHashMap();
        DecorationMapBuilder builder = new DecorationMapBuilder<R>(this){

            @Override
            public void put(String key, RvCategoryDecoration<R> decoration) {
                if ("info".equals(key) || "consume_block_in".equals(key)) {
                    lowPriorityDecorations.put(key, decoration);
                } else {
                    decorations.put((Object)key, decoration);
                }
            }

            @Override
            public void condition(String key, Predicate<R> predicate) {
                conditions.put((Object)key, predicate);
            }
        };
        this.setupDecorations(builder);
        decorations.putAll((Map)lowPriorityDecorations);
        this.decorations = decorations.buildKeepingLast();
        this.conditions = conditions.buildKeepingLast();
    }

    public void configureLayout(RvCategoryLayoutBuilder<R> builder, RecipeHolder<R> recipeHolder) {
        ILycheeRecipe recipe = (ILycheeRecipe)recipeHolder.value();
        builder.ingredientGroup(recipe, (Vector2fc)new Vector2f(27.0f, 28.0f));
        builder.actionGroup(recipe, (Vector2fc)new Vector2f((float)(builder.width() - 29), 28.0f));
    }

    public void setupDecorations(DecorationMapBuilder<R> mapBuilder) {
    }

    public Vector2fc infoPosition(R recipe) {
        return VectorExtensions.ZERO2F;
    }

    public static boolean needConsumeBlockInput(ILycheeRecipe<? extends LycheeContext> recipe) {
        return recipe.postActions().stream().anyMatch(it -> {
            PlaceBlock placeBlock;
            return it instanceof PlaceBlock && (placeBlock = (PlaceBlock)it).fancyDisplay();
        });
    }

    public static RenderElement consumeBlockInputIcon() {
        return new InteractiveRenderElement(element -> ((RenderElement)new SpriteElementRenderer(Lychee.id("exclamation_mark"), 2.0f).withSize(element.width(), element.height())).atZ(100.0f)).onTooltip(() -> List.of(Component.translatable((String)"postAction.lychee.place.consume"))).withSize(8, 8);
    }

    public static boolean needInfo(ILycheeRecipe<?> recipe) {
        return !recipe.conditions().conditions().isEmpty() || recipe.comment().map(it -> !Strings.isNullOrEmpty((String)it)).orElse(false) != false;
    }

    public static <R extends ILycheeRecipe<?>> RenderElement infoIcon(RecipeHolder<R> recipeHolder) {
        ILycheeRecipe recipe = (ILycheeRecipe)recipeHolder.value();
        return InteractiveRenderElement.create(new SpriteElementRenderer(AllGuiTextures.INFO.id).withSize(8)).onTooltip(() -> RVs.getRecipeTooltip(recipe)).onInput((action, element) -> ClientProxy.postWidgetInputEvent(recipeHolder.value(), recipeHolder.id().toString(), action, element)).withSize(8);
    }

    @FunctionalInterface
    public static interface WorkstationProvider<R extends ILycheeRecipe<LycheeContext>> {
        public List<Ingredient> get(RvCategoryInstance<R> var1);
    }

    @FunctionalInterface
    public static interface IconProvider<R extends ILycheeRecipe<LycheeContext>> {
        public RenderElement get(RvCategoryInstance<R> var1);
    }
}

