/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.recipeviewer.emi.ingredient;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.render.EmiTooltipComponents;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.screen.tooltip.EmiTextTooltipWrapper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import snownee.lychee.LycheeRegistries;
import snownee.lychee.contextual.Chance;
import snownee.lychee.util.action.ActionRenderer;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.contextual.ContextualConditionType;

public class PostActionEmiStack
extends EmiStack {
    private final PostAction action;

    public PostActionEmiStack(PostAction action) {
        this.action = action;
        Chance chance = action.conditions().conditions().stream().filter($ -> $.type() == ContextualConditionType.CHANCE).findFirst().orElse(null);
        if (chance != null) {
            this.setChance(chance.chance());
        }
    }

    public EmiStack copy() {
        return new PostActionEmiStack(this.action);
    }

    public void render(GuiGraphics draw, int x, int y, float delta, int flags) {
        ActionRenderer.of(this.action).internalRender(this.action, draw, x, y);
    }

    public boolean isEmpty() {
        return false;
    }

    public DataComponentPatch getComponentChanges() {
        return DataComponentPatch.EMPTY;
    }

    public Object getKey() {
        return this.action;
    }

    public ResourceLocation getId() {
        return LycheeRegistries.POST_ACTION.getKey(this.action.type());
    }

    public List<Component> getTooltipText() {
        return ActionRenderer.of(this.action).getTooltips(this.action, (Player)Minecraft.getInstance().player);
    }

    public List<ClientTooltipComponent> getTooltip() {
        ArrayList list = Lists.newArrayList();
        List<Component> text = this.getTooltipText();
        if (!text.isEmpty()) {
            list.add(new EmiTextTooltipWrapper((EmiIngredient)this, EmiPort.ordered((Component)text.getFirst())));
        }
        list.addAll(text.stream().skip(1L).map(EmiTooltipComponents::of).toList());
        String namespace = this.getId().getNamespace();
        EmiTooltipComponents.appendModName((List)list, (String)namespace);
        list.addAll(super.getTooltip());
        return list;
    }

    public Component getName() {
        return this.action.getDisplayName();
    }
}

