/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.recipeviewer.jei;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import me.shedaniel.rei.plugincompatibilities.api.REIPluginCompatIgnore;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import snownee.kiwi.util.KUtil;
import snownee.lychee.Lychee;
import snownee.lychee.RecipeTypes;
import snownee.lychee.client.gui.RenderElement;
import snownee.lychee.compat.recipeviewer.RvPlugin;
import snownee.lychee.compat.recipeviewer.SlotType;
import snownee.lychee.compat.recipeviewer.category.RvCategoryInstance;
import snownee.lychee.compat.recipeviewer.jei.category.CraftingRecipeCategoryExtension;
import snownee.lychee.compat.recipeviewer.jei.category.JeiRvHelper;
import snownee.lychee.compat.recipeviewer.jei.category.RvCategoryAdapter;
import snownee.lychee.compat.recipeviewer.jei.display.AnvilCraftingDisplay;
import snownee.lychee.compat.recipeviewer.jei.element.RenderElementAdapter;
import snownee.lychee.compat.recipeviewer.jei.ingredient.PostActionIngredientHelper;
import snownee.lychee.compat.recipeviewer.jei.ingredient.PostActionIngredientRenderer;
import snownee.lychee.recipes.AnvilCraftingRecipe;
import snownee.lychee.recipes.ShapedCraftingRecipe;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.recipe.ILycheeRecipe;

@REIPluginCompatIgnore
@JeiPlugin
public class LycheeJEIPlugin
implements IModPlugin {
    public static final ResourceLocation ID = Lychee.id("main");
    public static final IIngredientType<PostAction> POST_ACTION = () -> PostAction.class;
    private static final Map<SlotType, IDrawable> slotElements = Maps.toMap(List.of(SlotType.values()), it -> new RenderElementAdapter(RenderElement.create(it.sprite)));
    private final RvPlugin<JeiRvHelper> rvPlugin = new RvPlugin<JeiRvHelper>(JeiRvHelper.INSTANCE);

    public static IDrawable slot(SlotType type) {
        return slotElements.get((Object)type);
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        this.rvPlugin.helper().setJeiHelpers(registry.getJeiHelpers());
        this.rvPlugin.init();
        for (RvCategoryInstance rvCategory : this.rvPlugin.categories().values()) {
            registry.addRecipeCategories(new IRecipeCategory[]{new RvCategoryAdapter(rvCategory)});
        }
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        registration.getCraftingCategory().addExtension(ShapedCraftingRecipe.class, (ICraftingCategoryExtension)new CraftingRecipeCategoryExtension());
    }

    public void registerRecipes(IRecipeRegistration registry) {
        for (RvCategoryInstance instance : this.rvPlugin.categories().values()) {
            registry.addRecipes((RecipeType)registry.getJeiHelpers().getRecipeType(instance.id()).orElseThrow(), instance.recipes());
        }
        try {
            List<IJeiAnvilRecipe> recipes = KUtil.getRecipes(RecipeTypes.ANVIL_CRAFTING).stream().filter($ -> !((AnvilCraftingRecipe)$.value()).output().isEmpty() && !((AnvilCraftingRecipe)$.value()).isSpecial() && !((AnvilCraftingRecipe)$.value()).hideInRecipeViewer()).map($ -> AnvilCraftingDisplay.of((RecipeHolder<AnvilCraftingRecipe>)$)).toList();
            registry.addRecipes(mezz.jei.api.constants.RecipeTypes.ANVIL, recipes);
        }
        catch (Throwable e) {
            Lychee.LOGGER.error("Error when registering anvil crafting recipes", e);
        }
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        registration.register(POST_ACTION, List.of(), (IIngredientHelper)new PostActionIngredientHelper(), (IIngredientRenderer)PostActionIngredientRenderer.INSTANCE, PostAction.CODEC);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        for (RvCategoryInstance instance : this.rvPlugin.categories().values()) {
            RecipeType recipeType = (RecipeType)registry.getJeiHelpers().getRecipeType(instance.id()).orElseThrow();
            for (Ingredient ingredient : instance.workstations()) {
                registry.addRecipeCatalysts(recipeType, ingredient.getItems());
            }
        }
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        this.rvPlugin.helper().setRuntime(jeiRuntime);
        Minecraft.getInstance().execute(() -> {
            List<RecipeHolder> recipes = KUtil.getRecipes((net.minecraft.world.item.crafting.RecipeType)net.minecraft.world.item.crafting.RecipeType.CRAFTING).stream().filter($ -> {
                ILycheeRecipe recipe;
                Recipe patt0$temp = $.value();
                return patt0$temp instanceof ILycheeRecipe && (recipe = (ILycheeRecipe)patt0$temp).hideInRecipeViewer();
            }).toList();
            jeiRuntime.getRecipeManager().hideRecipes(mezz.jei.api.constants.RecipeTypes.CRAFTING, recipes);
        });
    }

    public void onRuntimeUnavailable() {
        this.rvPlugin.helper().setJeiHelpers(null);
        this.rvPlugin.helper().setRuntime(null);
    }
}

