/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.recipeviewer.jei.element;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.inputs.IJeiGuiEventListener;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import snownee.lychee.client.gui.InteractiveRenderElement;
import snownee.lychee.client.gui.RenderElement;

public class RenderElementAdapter
implements IRecipeWidget,
IJeiGuiEventListener,
IDrawable {
    private final RenderElement element;
    private final ScreenRectangle bounds;

    public RenderElementAdapter(RenderElement element) {
        this.element = element;
        this.bounds = new ScreenRectangle((int)element.x(), (int)element.y(), element.width(), element.height());
    }

    public int getWidth() {
        return this.element.width();
    }

    public int getHeight() {
        return this.element.height();
    }

    public void draw(GuiGraphics guiGraphics, int xOffset, int yOffset) {
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        pose.translate((float)xOffset, (float)yOffset, this.element.z());
        this.element.render(guiGraphics);
        pose.popPose();
    }

    public void drawWidget(GuiGraphics guiGraphics, double mouseX, double mouseY) {
        RenderElement renderElement = this.element;
        if (renderElement instanceof InteractiveRenderElement) {
            InteractiveRenderElement interactive = (InteractiveRenderElement)renderElement;
            interactive.updateHoverState((double)this.element.x() + mouseX, (double)this.element.y() + mouseY);
        }
        this.draw(guiGraphics, (int)(-this.element.x()), (int)(-this.element.y()));
    }

    public ScreenRectangle getArea() {
        return this.bounds;
    }

    public ScreenPosition getPosition() {
        return this.bounds.position();
    }

    public void getTooltip(ITooltipBuilder tooltip, double mouseX, double mouseY) {
        InteractiveRenderElement interactive;
        RenderElement renderElement = this.element;
        if (!(renderElement instanceof InteractiveRenderElement) || !(interactive = (InteractiveRenderElement)renderElement).isHovered()) {
            return;
        }
        List<Component> components = interactive.getTooltip();
        if (components == null) {
            return;
        }
        tooltip.clear();
        tooltip.addAll(components);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        RenderElement renderElement = this.element;
        if (!(renderElement instanceof GuiEventListener)) {
            return false;
        }
        GuiEventListener listener = (GuiEventListener)renderElement;
        return listener.mouseClicked(-1.0, -1.0, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        RenderElement renderElement = this.element;
        if (!(renderElement instanceof GuiEventListener)) {
            return false;
        }
        GuiEventListener listener = (GuiEventListener)renderElement;
        return listener.mouseScrolled(-1.0, -1.0, scrollX, scrollY);
    }

    public boolean keyPressed(double mouseX, double mouseY, int keyCode, int scanCode, int modifiers) {
        RenderElement renderElement = this.element;
        if (!(renderElement instanceof GuiEventListener)) {
            return false;
        }
        GuiEventListener listener = (GuiEventListener)renderElement;
        return listener.keyPressed(keyCode, scanCode, modifiers);
    }
}

