/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.recipeviewer.rei.category;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import snownee.lychee.compat.recipeviewer.RvHelper;
import snownee.lychee.util.ui.InputAction;

public class ReiRvHelper
extends RvHelper {
    public static final ReiRvHelper INSTANCE = new ReiRvHelper();

    @Override
    public boolean doAction(ItemStack stack, InputAction.Direct action) {
        if (stack.isEmpty()) {
            return false;
        }
        return this.doAction(EntryStacks.of((ItemStack)stack), action);
    }

    @Override
    public boolean doAction(Fluid fluid, InputAction.Direct action) {
        return this.doAction(EntryStacks.of((Fluid)fluid), action);
    }

    @Override
    public Optional<InputAction.Direct> toDirectAction(InputAction action) {
        if (action instanceof InputAction.Direct) {
            InputAction.Direct direct = (InputAction.Direct)action;
            return Optional.of(direct);
        }
        ConfigObject configObject = ConfigObject.getInstance();
        List<Map.Entry<ModifierKeyCode, InputAction.Direct>> keys = List.of(Map.entry(configObject.getRecipeKeybind(), InputAction.Direct.SHOW_RECIPES), Map.entry(configObject.getUsageKeybind(), InputAction.Direct.SHOW_USAGES), Map.entry(configObject.getFavoriteKeyCode(), InputAction.Direct.FAVORITE));
        for (Map.Entry<ModifierKeyCode, InputAction.Direct> entry : keys) {
            if (action instanceof InputAction.KeyPressed) {
                InputAction.KeyPressed keyPressed = (InputAction.KeyPressed)action;
                if (!entry.getKey().matchesKey(keyPressed.keyCode, keyPressed.scanCode)) continue;
                return Optional.of(entry.getValue());
            }
            if (!(action instanceof InputAction.MousePressed)) continue;
            InputAction.MousePressed mousePressed = (InputAction.MousePressed)action;
            if (!entry.getKey().matchesMouse(mousePressed.button)) continue;
            return Optional.of(entry.getValue());
        }
        if (action instanceof InputAction.MousePressed) {
            InputAction.MousePressed mousePressed = (InputAction.MousePressed)action;
            if (configObject.getRecipeKeybind().getType() != InputConstants.Type.MOUSE && mousePressed.button == 0) {
                return Optional.of(InputAction.Direct.SHOW_RECIPES);
            }
            if (configObject.getUsageKeybind().getType() != InputConstants.Type.MOUSE && mousePressed.button == 1) {
                return Optional.of(InputAction.Direct.SHOW_USAGES);
            }
        }
        return Optional.empty();
    }

    @Override
    public boolean appendModName() {
        return ConfigObject.getInstance().shouldAppendModNames();
    }

    public boolean doAction(EntryStack<?> entry, InputAction.Direct action) {
        if (action == InputAction.Direct.SHOW_RECIPES) {
            return ViewSearchBuilder.builder().addRecipesFor(entry).open();
        }
        if (action == InputAction.Direct.SHOW_USAGES) {
            return ViewSearchBuilder.builder().addUsagesFor(entry).open();
        }
        if (action == InputAction.Direct.FAVORITE) {
            FavoriteEntry favoriteEntry = FavoriteEntry.fromEntryStack(entry);
            ConfigObject.getInstance().getFavoriteEntries().add(favoriteEntry);
            return true;
        }
        return false;
    }
}

