/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.recipeviewer.rei.element;

import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.client.gui.ScreenElement;

public class LycheeEntryWidget
extends EntryWidget {
    private ScreenElement bg;
    private List<Component> extraTooltips = List.of();

    public LycheeEntryWidget(Point point) {
        super(point);
    }

    public LycheeEntryWidget(Rectangle bounds) {
        super(bounds);
    }

    protected void drawBackground(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.background) {
            super.drawBackground(graphics, mouseX, mouseY, delta);
        } else if (this.bg != null) {
            Rectangle rect = this.getBounds();
            graphics.pose().pushPose();
            graphics.pose().translate((float)rect.x, (float)rect.y, 0.0f);
            this.bg.render(graphics);
            graphics.pose().popPose();
        }
    }

    public void background(ScreenElement bg) {
        this.disableBackground();
        this.bg = bg;
    }

    @Nullable
    public Tooltip getCurrentTooltip(TooltipContext context) {
        Tooltip tooltip = super.getCurrentTooltip(context);
        if (!this.extraTooltips.isEmpty()) {
            if (tooltip == null) {
                tooltip = Tooltip.create((Component[])new Component[0]);
            }
            tooltip.addAllTexts(this.extraTooltips);
        }
        return tooltip;
    }

    public void setExtraTooltips(List<Component> tooltips) {
        this.extraTooltips = tooltips;
    }
}

