/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.recipeviewer.rei.element;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import snownee.lychee.client.gui.InteractiveRenderElement;
import snownee.lychee.client.gui.RenderElement;

public class RenderElementAdapter
extends WidgetWithBounds {
    private final RenderElement element;
    private final Rectangle bounds;
    private final Vector2f startPoint;

    public RenderElementAdapter(RenderElement element) {
        this.element = element;
        this.bounds = new Rectangle((double)element.x(), (double)element.y(), (double)element.width(), (double)element.height());
        this.startPoint = new Vector2f(0.0f, 0.0f);
    }

    public RenderElementAdapter(RenderElement element, Point startPoint) {
        this(element);
        this.startPoint.set((float)startPoint.x, (float)startPoint.y);
        this.bounds.x += startPoint.x;
        this.bounds.y += startPoint.y;
    }

    public RenderElementAdapter(RenderElement element, Vector2fc startPoint) {
        this(element);
        this.startPoint.set(startPoint);
        this.bounds.x += (int)startPoint.x();
        this.bounds.y += (int)startPoint.y();
    }

    public List<? extends GuiEventListener> children() {
        return List.of();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        RenderElement renderElement = this.element;
        if (!(renderElement instanceof GuiEventListener)) {
            return false;
        }
        GuiEventListener listener = (GuiEventListener)renderElement;
        double relMouseX = mouseX - (double)this.startPoint.x();
        double relMouseY = mouseY - (double)this.startPoint.y();
        return listener.mouseClicked(relMouseX, relMouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        RenderElement renderElement = this.element;
        if (!(renderElement instanceof GuiEventListener)) {
            return false;
        }
        GuiEventListener listener = (GuiEventListener)renderElement;
        double relMouseX = mouseX - (double)this.startPoint.x();
        double relMouseY = mouseY - (double)this.startPoint.y();
        return listener.mouseScrolled(relMouseX, relMouseY, scrollX, scrollY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        RenderElement renderElement = this.element;
        if (!(renderElement instanceof GuiEventListener)) {
            return false;
        }
        GuiEventListener listener = (GuiEventListener)renderElement;
        return listener.keyPressed(keyCode, scanCode, modifiers);
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        double relMouseX = (float)mouseX - this.startPoint.x();
        double relMouseY = (float)mouseY - this.startPoint.y();
        RenderElement renderElement = this.element;
        if (renderElement instanceof InteractiveRenderElement) {
            List<Component> tooltip;
            InteractiveRenderElement interactive = (InteractiveRenderElement)renderElement;
            interactive.updateHoverState(relMouseX, relMouseY);
            if (interactive.isHovered() && (tooltip = interactive.getTooltip()) != null) {
                Tooltip.create(tooltip).queue();
            }
        }
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        pose.translate((float)this.bounds.x - this.element.x(), (float)this.bounds.y - this.element.y(), 0.0f);
        this.element.render(guiGraphics, (int)relMouseX, (int)relMouseY, partialTick);
        pose.popPose();
    }
}

