/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.context;

import com.google.common.collect.Sets;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeLootContextParamSets;
import snownee.lychee.context.LootParamInit;

public class LootParamsContext {
    private final Map<LootContextParam<?>, @Nullable Object> params = new IdentityHashMap();
    private final Level level;
    private final LootContextParamSet paramSet;
    private boolean validated;

    public LootParamsContext(Level level, LootContextParamSet paramSet) {
        this.level = level;
        this.paramSet = paramSet;
    }

    public Map<LootContextParam<?>, @Nullable Object> params() {
        return this.params;
    }

    public LootContextParamSet paramSet() {
        return this.paramSet;
    }

    public boolean has(LootContextParam<?> param) {
        return this.params.get(param) != null;
    }

    public <T> T get(LootContextParam<T> param) {
        T result = this.getOrNull(param);
        if (result == null) {
            throw new NoSuchElementException(param.getName().toString());
        }
        return result;
    }

    @Nullable
    public <T> T getOrNull(LootContextParam<T> param) {
        return (T)this.params.computeIfAbsent(param, this::init);
    }

    public <T> void set(LootContextParam<T> param, @Nullable T value) {
        this.params.put(param, value);
        if (this.validated && param == LootContextParams.ORIGIN) {
            for (LootContextParam<?> initParam : LootParamInit.LOOKUP.keySet()) {
                if (initParam == LootContextParams.ORIGIN) continue;
                this.params.remove(initParam);
            }
        }
    }

    public void remove(LootContextParam<?> param) {
        this.set(param, null);
    }

    public LootContext asLootContext() {
        this.initAll();
        LootParams.Builder paramsBuilder = new LootParams.Builder((ServerLevel)this.level);
        this.params.forEach((p, o) -> {
            if (o != null) {
                paramsBuilder.withParameter(p, o);
            }
        });
        LootContext.Builder builder = new LootContext.Builder(paramsBuilder.create(LycheeLootContextParamSets.ALL));
        return builder.create(Optional.empty());
    }

    public void validate() {
        this.validate(this.paramSet);
    }

    public void validate(LootContextParamSet paramSet) {
        Sets.SetView difference = Sets.difference((Set)paramSet.getRequired(), this.params.keySet());
        if (!difference.isEmpty()) {
            throw new IllegalArgumentException("Missing required parameters: " + String.valueOf(difference));
        }
        this.validated = true;
    }

    public void initAll() {
        for (LootContextParam<?> param : LootParamInit.LOOKUP.keySet()) {
            this.getOrNull(param);
        }
    }

    @Nullable
    @CheckReturnValue
    public Object init(LootContextParam<?> param) {
        LootParamInit init = LootParamInit.LOOKUP.get(param);
        if (init != null) {
            return init.init(this.level, this);
        }
        return null;
    }
}

