/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.contextual;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.contextual.ContextualCondition;
import snownee.lychee.util.contextual.ContextualConditionType;
import snownee.lychee.util.recipe.ILycheeRecipe;

public class DirectionCheck
implements ContextualCondition {
    public static final Map<String, DirectionCheck> LOOKUPS = Maps.newHashMap();
    private final String name;
    private final Predicate<LycheeContext> predicate;

    public static void createLookup(String name, Predicate<LycheeContext> predicate) {
        LOOKUPS.put(name, new DirectionCheck(name, predicate));
    }

    private DirectionCheck(String name, Predicate<LycheeContext> predicate) {
        this.name = name;
        this.predicate = predicate;
    }

    public ContextualConditionType<DirectionCheck> type() {
        return ContextualConditionType.DIRECTION;
    }

    @Override
    public int test(@Nullable ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        return this.predicate.test(ctx) ? times : 0;
    }

    @Override
    public MutableComponent getDescription(boolean inverted) {
        MutableComponent value = Component.translatable((String)("direction.lychee." + this.name)).withStyle(ChatFormatting.WHITE);
        return Component.translatable((String)this.getDescriptionId(inverted), (Object[])new Object[]{value});
    }

    static {
        for (Direction direction : Direction.values()) {
            DirectionCheck.createLookup(direction.getName().toLowerCase(Locale.ENGLISH), ctx -> ctx.get(LycheeContextKey.LOOT_PARAMS).get(LycheeLootContextParams.DIRECTION) == direction);
        }
        DirectionCheck.createLookup("sides", ctx -> ctx.get(LycheeContextKey.LOOT_PARAMS).get(LycheeLootContextParams.DIRECTION).getStepY() == 0);
        DirectionCheck.createLookup("forward", ctx -> {
            BlockState state;
            Direction facing;
            LootParamsContext lootParams = ctx.get(LycheeContextKey.LOOT_PARAMS);
            Direction direction = lootParams.get(LycheeLootContextParams.DIRECTION);
            return direction == (facing = (Direction)(state = (BlockState)lootParams.get(LootContextParams.BLOCK_STATE)).getOptionalValue((Property)BlockStateProperties.FACING).or(() -> state.getOptionalValue((Property)BlockStateProperties.HORIZONTAL_FACING)).or(() -> state.getOptionalValue((Property)BlockStateProperties.VERTICAL_DIRECTION)).orElseThrow());
        });
        DirectionCheck.createLookup("axis", ctx -> {
            LootParamsContext lootParams = ctx.get(LycheeContextKey.LOOT_PARAMS);
            Direction direction = lootParams.get(LycheeLootContextParams.DIRECTION);
            BlockState state = (BlockState)lootParams.get(LootContextParams.BLOCK_STATE);
            Direction.Axis axis = (Direction.Axis)state.getOptionalValue((Property)BlockStateProperties.AXIS).or(() -> state.getOptionalValue((Property)BlockStateProperties.HORIZONTAL_AXIS)).orElseThrow();
            return axis.test(direction);
        });
    }

    public static class Type
    implements ContextualConditionType<DirectionCheck> {
        public static final MapCodec<DirectionCheck> CODEC = Codec.stringResolver($ -> $.name, LOOKUPS::get).fieldOf("direction");

        @Override
        public MapCodec<DirectionCheck> codec() {
            return CODEC;
        }
    }
}

