/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.contextual;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.util.BoundsExtensions;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.contextual.ContextualCondition;
import snownee.lychee.util.contextual.ContextualConditionType;
import snownee.lychee.util.recipe.ILycheeRecipe;

public record FallDistance(MinMaxBounds.Doubles range) implements ContextualCondition
{
    public ContextualConditionType<FallDistance> type() {
        return ContextualConditionType.FALL_DISTANCE;
    }

    @Override
    public int test(@Nullable ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        Entity entity = (Entity)ctx.get(LycheeContextKey.LOOT_PARAMS).get(LootContextParams.THIS_ENTITY);
        float distance = entity.fallDistance;
        if (entity instanceof FallingBlockEntity) {
            FallingBlockEntity block = (FallingBlockEntity)entity;
            distance = (float)Math.max((double)block.getStartPos().getY() - block.getY(), (double)distance);
        }
        return this.range.matches((double)distance) ? times : 0;
    }

    @Override
    public MutableComponent getDescription(boolean inverted) {
        return Component.translatable((String)this.getDescriptionId(inverted), (Object[])new Object[]{BoundsExtensions.getDescription(this.range)});
    }

    public static class Type
    implements ContextualConditionType<FallDistance> {
        public static final MapCodec<FallDistance> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MinMaxBounds.Doubles.CODEC.fieldOf("range").forGetter(FallDistance::range)).apply((Applicative)instance, FallDistance::new));

        @Override
        public MapCodec<FallDistance> codec() {
            return CODEC;
        }
    }
}

