/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.contextual;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.contextual.ContextualCondition;
import snownee.lychee.util.contextual.ContextualConditionType;
import snownee.lychee.util.recipe.ILycheeRecipe;

public record IsWeather(String id, Predicate<Level> predicate) implements ContextualCondition
{
    public static final Map<String, IsWeather> REGISTRY = Maps.newConcurrentMap();
    public static IsWeather CLEAR = IsWeather.create("clear", level -> !level.isRaining() && !level.isThundering());
    public static IsWeather RAIN = IsWeather.create("rain", Level::isRaining);
    public static IsWeather THUNDER = IsWeather.create("thunder", Level::isThundering);

    public static IsWeather create(String id, Predicate<Level> predicate) {
        IsWeather isWeather = new IsWeather(id, predicate);
        REGISTRY.put(id, isWeather);
        return isWeather;
    }

    public ContextualConditionType<IsWeather> type() {
        return ContextualConditionType.WEATHER;
    }

    @Override
    public int test(@Nullable ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        return this.predicate.test(ctx.level()) ? times : 0;
    }

    @Override
    public TriState testForTooltips(Level level, @Nullable Player player) {
        return TriState.of((boolean)this.predicate.test(level));
    }

    @Override
    public MutableComponent getDescription(boolean inverted) {
        String key = this.getDescriptionId(inverted);
        MutableComponent weather = Component.translatable((String)("weather.lychee." + this.id));
        return Component.translatable((String)key, (Object[])new Object[]{weather.withStyle(ChatFormatting.WHITE)});
    }

    public static class Type
    implements ContextualConditionType<IsWeather> {
        public static final MapCodec<IsWeather> CODEC = Codec.stringResolver(IsWeather::id, REGISTRY::get).fieldOf("weather");
        public static final StreamCodec<ByteBuf, IsWeather> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(REGISTRY::get, IsWeather::id);

        @Override
        public MapCodec<IsWeather> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, IsWeather> streamCodec() {
            return STREAM_CODEC.cast();
        }
    }
}

