/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.contextual;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeRegistries;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.contextual.ContextualCondition;
import snownee.lychee.util.contextual.ContextualConditionType;
import snownee.lychee.util.recipe.ILycheeRecipe;

public record Param(Holder<LycheeContextKey<?>> key, boolean create, String loot) implements ContextualCondition
{
    public Param(Holder<LycheeContextKey<?>> key, String loot) {
        this(key, true, loot);
    }

    public ContextualConditionType<Param> type() {
        return ContextualConditionType.PARAM;
    }

    @Override
    public MutableComponent getDescription(boolean inverted) {
        String s = this.getDescriptionId(inverted) + ".has";
        Object value = ((ResourceKey)this.key.unwrapKey().orElseThrow()).toString();
        if (!this.loot.isEmpty()) {
            value = (String)value + "." + this.loot;
        }
        return Component.translatable((String)s, (Object[])new Object[]{CommonProxy.white((CharSequence)value)});
    }

    @Override
    public int test(@Nullable ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        if (!ctx.has((LycheeContextKey)this.key.value(), this.create)) {
            return 0;
        }
        if (!this.loot.isEmpty()) {
            boolean found = false;
            LootParamsContext lootParams = ctx.get(LycheeContextKey.LOOT_PARAMS);
            if (this.create) {
                lootParams.initAll();
            }
            for (Map.Entry<LootContextParam<?>, Object> entry : lootParams.params().entrySet()) {
                LootContextParam<?> param;
                if (entry.getValue() == null || !this.loot.equals((param = entry.getKey()).getName().getPath()) && !this.loot.equals(param.getName().toString())) continue;
                found = true;
                break;
            }
            if (!found) {
                return 0;
            }
        }
        return times;
    }

    public static class Type
    implements ContextualConditionType<Param> {
        public static final MapCodec<Param> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)LycheeRegistries.CONTEXT.holderByNameCodec().fieldOf("key").forGetter(Param::key), (App)Codec.BOOL.optionalFieldOf("create", (Object)true).forGetter(Param::create), (App)Codec.STRING.optionalFieldOf("loot", (Object)"").forGetter(Param::loot)).apply((Applicative)i, Param::new)).validate(it -> {
            if (!it.loot.isEmpty() && it.key.value() != LycheeContextKey.LOOT_PARAMS) {
                return DataResult.error(() -> "`loot` can only be used with `loot_params` key");
            }
            return DataResult.success((Object)it);
        });
        public static final StreamCodec<RegistryFriendlyByteBuf, Param> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)LycheeRegistries.CONTEXT.key()), Param::key, (StreamCodec)ByteBufCodecs.STRING_UTF8, Param::loot, Param::new);

        @Override
        public MapCodec<Param> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, Param> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

