/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.datagen;

import com.google.common.collect.Lists;
import dev.latvian.mods.rhino.util.RemapForJS;
import java.util.List;
import org.jetbrains.annotations.Contract;
import snownee.lychee.contextual.Chance;
import snownee.lychee.util.contextual.ContextualCondition;
import snownee.lychee.util.contextual.ContextualConditionData;
import snownee.lychee.util.contextual.ContextualHolder;

public class ContextualBuilder<T> {
    protected final List<ContextualConditionData> conditions = Lists.newArrayListWithExpectedSize((int)4);

    @Contract(value="-> this")
    protected final T self() {
        return (T)this;
    }

    public ContextualHolder contextualHolder() {
        return ContextualHolder.pack(this.conditions);
    }

    @Contract(value="_ -> this")
    public T condition(ContextualCondition condition) {
        return this.condition(new ContextualConditionData(condition));
    }

    @RemapForJS(value="conditionData")
    @Contract(value="_ -> this")
    public T condition(ContextualConditionData condition) {
        this.conditions.add(condition);
        return this.self();
    }

    @RemapForJS(value="conditionHolder")
    @Contract(value="_ -> this")
    public T condition(ContextualHolder conditions) {
        this.conditions.addAll(conditions.unpack());
        return this.self();
    }

    @Contract(value="_ -> this")
    public T chance(float chance) {
        return this.condition(new Chance(chance));
    }
}

