/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.mixin;

import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DropperBlock;
import net.minecraft.world.level.block.Fallable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import snownee.lychee.LycheeConfig;
import snownee.lychee.LycheeTags;
import snownee.lychee.util.CommonProxy;

@Mixin(value={DefaultDispenseItemBehavior.class})
public class DefaultDispenseItemBehaviorMixin {
    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;split(I)Lnet/minecraft/world/item/ItemStack;")}, method={"execute"}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    private void execute(BlockSource pSource, ItemStack pStack, CallbackInfoReturnable<ItemStack> ci, Direction direction, Position position) {
        if (this == DropperBlock.DISPENSE_BEHAVIOUR) {
            return;
        }
        Item item = pStack.getItem();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem item2 = (BlockItem)item;
        Block block = item2.getBlock();
        if (!(pStack.is(LycheeTags.DISPENSER_PLACEMENT) || LycheeConfig.dispenserFallableBlockPlacement && block instanceof Fallable)) {
            return;
        }
        if (CommonProxy.dispensePlacement(pSource, pStack, direction)) {
            ci.setReturnValue((Object)pStack);
        }
    }
}

