/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.mixin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import snownee.kiwi.util.resource.OneTimeLoader;
import snownee.lychee.LycheeConfig;
import snownee.lychee.util.json.JsonFragmentManager;

@Mixin(value={RecipeManager.class}, priority=333)
public class RecipeManagerMixin {
    @Unique
    private static final ThreadLocal<JsonFragmentManager> fragmentManagerProvider = new ThreadLocal();

    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="HEAD")})
    private void lychee_beginApply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler, CallbackInfo ci) {
        if (LycheeConfig.enableYamlRecipes) {
            Map yamlRecipes = OneTimeLoader.load((ResourceManager)resourceManager, (String)Registries.elementsDirPath((ResourceKey)Registries.RECIPE), (Codec)ExtraCodecs.JSON, (OneTimeLoader.Context)new OneTimeLoader.Context());
            for (Map.Entry entry : yamlRecipes.entrySet()) {
                object.putIfAbsent((ResourceLocation)entry.getKey(), (JsonElement)entry.getValue());
            }
        }
        if (LycheeConfig.enableFragment) {
            JsonFragmentManager fragmentManager = new JsonFragmentManager(resourceManager);
            fragmentManagerProvider.set(fragmentManager);
            object.values().forEach(fragmentManager::process);
        }
    }

    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="RETURN")})
    private void lychee_endApply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler, CallbackInfo ci) {
        if (LycheeConfig.enableFragment) {
            fragmentManagerProvider.remove();
        }
    }

    @Inject(method={"fromJson"}, at={@At(value="HEAD")})
    private static void lychee_fromJson(ResourceLocation resourceLocation, JsonObject json, HolderLookup.Provider provider, CallbackInfoReturnable<RecipeHolder<?>> cir) {
        JsonFragmentManager fragmentManager;
        if (LycheeConfig.enableFragment && json != null && (fragmentManager = fragmentManagerProvider.get()) != null) {
            fragmentManager.process((JsonElement)json);
        }
    }
}

