/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.mixin.action;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import snownee.lychee.Lychee;
import snownee.lychee.context.ActionContext;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.util.action.ActionData;
import snownee.lychee.util.action.ActionMarker;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;

@Mixin(value={Marker.class})
public class MarkerMixin
implements ActionMarker {
    @Unique
    @Nullable
    private ActionData lychee$data;

    @Override
    @Nullable
    public ActionData lychee$getData() {
        return this.lychee$data;
    }

    @Override
    public void lychee$setData(ActionData lychee$data) {
        this.lychee$data = lychee$data;
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    private void lychee_tick(CallbackInfo ci) {
        if (this.lychee$data == null) {
            return;
        }
        if (this.lychee$self().tickCount > 6000) {
            this.lychee$self().discard();
            return;
        }
        if (this.lychee$data.consumeDelayedTicks() > 0) {
            return;
        }
        LycheeContext context = this.lychee$data.getContext();
        context.put(LycheeContextKey.LEVEL, this.lychee$self().level());
        ActionContext actionContext = context.get(LycheeContextKey.ACTION);
        actionContext.state = ActionContext.State.RUNNING;
        actionContext.run(context);
        if (actionContext.state == ActionContext.State.STOPPED) {
            this.lychee$self().discard();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"readAdditionalSaveData"})
    private void lychee_readAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        if (!compoundTag.contains("lychee")) {
            return;
        }
        CompoundTag tag = compoundTag.getCompound("lychee");
        DataResult result = ActionData.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag);
        if (result.isError()) {
            Lychee.LOGGER.error("Load Lychee action data: {} -> {}", (Object)tag, (Object)((DataResult.Error)result.error().orElseThrow()).message());
            this.lychee$self().discard();
            return;
        }
        this.lychee$data = (ActionData)result.getOrThrow();
        LycheeContext context = this.lychee$data.getContext();
        if (context.has(LycheeContextKey.RECIPE_ID, false)) {
            context.has(LycheeContextKey.RECIPE, true);
        }
        context.put(LycheeContextKey.MARKER, this);
        LootParamsContext lootParams = context.get(LycheeContextKey.LOOT_PARAMS);
        lootParams.set(LootContextParams.ORIGIN, this.lychee$self().position());
        try {
            lootParams.validate();
        }
        catch (IllegalArgumentException e) {
            Lychee.LOGGER.error("Load Lychee action data: {} -> {}", (Object)tag, (Object)e.getMessage());
            this.lychee$self().discard();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"addAdditionalSaveData"})
    private void lychee_addAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        if (this.lychee$data == null) {
            return;
        }
        DataResult result = ActionData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.lychee$data);
        if (result.isSuccess()) {
            compoundTag.put("lychee", (Tag)result.getOrThrow());
        } else {
            Lychee.LOGGER.error("{}: {}", (Object)this.lychee$data, (Object)((DataResult.Error)result.error().orElseThrow()).message());
        }
    }
}

