/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import snownee.lychee.client.gui.LycheeGuiGraphics;

@Mixin(value={GuiGraphics.class})
public abstract class GuiGraphicsMixin
implements LycheeGuiGraphics {
    @Shadow
    @Final
    private PoseStack pose;
    @Unique
    @Nullable
    private Function<ResourceLocation, RenderType> lychee$renderType;

    @Shadow
    public abstract MultiBufferSource.BufferSource bufferSource();

    @Inject(method={"innerBlit(Lnet/minecraft/resources/ResourceLocation;IIIIIFFFF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void lychee_innerBlit(ResourceLocation atlasLocation, int x1, int x2, int y1, int y2, int blitOffset, float minU, float maxU, float minV, float maxV, CallbackInfo ci) {
        if (this.lychee$renderType == null) {
            return;
        }
        MultiBufferSource.BufferSource bufferSource = this.bufferSource();
        RenderType renderType = this.lychee$renderType.apply(atlasLocation);
        VertexConsumer buffer = bufferSource.getBuffer(renderType);
        Matrix4f matrix4f = this.pose.last().pose();
        buffer.addVertex(matrix4f, (float)x1, (float)y1, (float)blitOffset).setUv(minU, minV);
        buffer.addVertex(matrix4f, (float)x1, (float)y2, (float)blitOffset).setUv(minU, maxV);
        buffer.addVertex(matrix4f, (float)x2, (float)y2, (float)blitOffset).setUv(maxU, maxV);
        buffer.addVertex(matrix4f, (float)x2, (float)y1, (float)blitOffset).setUv(maxU, minV);
        bufferSource.endBatch(renderType);
        ci.cancel();
    }

    @Override
    public void lychee$setRenderType(@Nullable Function<ResourceLocation, RenderType> renderType) {
        this.lychee$renderType = renderType;
    }
}

