/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.network;

import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import snownee.kiwi.contributor.network.CSetCosmeticPacket;
import snownee.kiwi.network.KPacketSender;
import snownee.kiwi.network.KiwiPacket;
import snownee.kiwi.network.PayloadContext;
import snownee.kiwi.network.PlayPacketHandler;
import snownee.lychee.Lychee;

@KiwiPacket
public record SCustomLevelEventPacket(ItemStack stack, Vector3f pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CSetCosmeticPacket> TYPE = new CustomPacketPayload.Type(Lychee.id("level_event"));

    public SCustomLevelEventPacket(ItemStack stack, Vec3 pos) {
        this(stack, pos.toVector3f());
    }

    public void sendToAround(ServerLevel level) {
        KPacketSender.sendToAround((CustomPacketPayload)this, (ServerLevel)level, null, (Vec3)new Vec3(this.pos), (double)16.0);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static class Handler
    implements PlayPacketHandler<SCustomLevelEventPacket> {
        public static final StreamCodec<RegistryFriendlyByteBuf, SCustomLevelEventPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, SCustomLevelEventPacket::stack, (StreamCodec)ByteBufCodecs.VECTOR3F, SCustomLevelEventPacket::pos, SCustomLevelEventPacket::new);

        public StreamCodec<RegistryFriendlyByteBuf, SCustomLevelEventPacket> streamCodec() {
            return STREAM_CODEC;
        }

        public void handle(SCustomLevelEventPacket packet, PayloadContext context) {
            context.execute(() -> {
                for (int i = 0; i < 8; ++i) {
                    Vec3 vec3 = new Vec3((Math.random() - 0.5) * 0.2, Math.random() * 0.1 + 0.1, (Math.random() - 0.5) * 0.2);
                    Minecraft.getInstance().level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, packet.stack), (double)packet.pos.x, (double)packet.pos.y, (double)packet.pos.z, vec3.x, vec3.y + 0.05, vec3.z);
                }
            });
        }
    }
}

