/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.recipes;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import snownee.kiwi.recipe.SizedIngredient;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.RecipeSerializers;
import snownee.lychee.RecipeTypes;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.recipes.BlockInteractingRecipe;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.recipe.BlockKeyableRecipeType;
import snownee.lychee.util.recipe.LycheeRecipe;
import snownee.lychee.util.recipe.LycheeRecipeCommonProperties;
import snownee.lychee.util.recipe.LycheeRecipeSerializer;

public class BlockClickingRecipe
extends BlockInteractingRecipe {
    public static InteractionResult invoke(Player player, Level level, InteractionHand hand, BlockPos pos, Direction direction) {
        if (player.isSpectator()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.getItemInHand(hand);
        if (player.getCooldowns().isOnCooldown(stack.getItem())) {
            return InteractionResult.PASS;
        }
        Vec3 vec = Vec3.atCenterOf((Vec3i)pos);
        LycheeContext context = new LycheeContext();
        context.put(LycheeContextKey.LEVEL, level);
        LootParamsContext lootParams = context.initLootParams(RecipeTypes.BLOCK_CLICKING);
        lootParams.set(LycheeLootContextParams.DIRECTION, direction);
        Optional result = RecipeTypes.BLOCK_CLICKING.process(player, hand, pos, vec, context);
        return result.map(it -> InteractionResult.SUCCESS).orElse(InteractionResult.PASS);
    }

    public BlockClickingRecipe(LycheeRecipeCommonProperties commonProperties, List<SizedIngredient> input, BlockPredicate blockPredicate) {
        super(commonProperties, input, blockPredicate);
    }

    @Override
    public LycheeRecipeSerializer<? extends BlockClickingRecipe> getSerializer() {
        return RecipeSerializers.BLOCK_CLICKING;
    }

    @Override
    public BlockKeyableRecipeType<? extends BlockClickingRecipe> getType() {
        return RecipeTypes.BLOCK_CLICKING;
    }

    public static class Serializer
    implements LycheeRecipeSerializer<BlockClickingRecipe> {
        public static MapCodec<BlockClickingRecipe> CODEC = BlockInteractingRecipe.codec(BlockClickingRecipe::new);
        public static final StreamCodec<RegistryFriendlyByteBuf, BlockClickingRecipe> STREAM_CODEC = StreamCodec.composite(LycheeRecipeCommonProperties.STREAM_CODEC, LycheeRecipe::commonProperties, (StreamCodec)SizedIngredient.STREAM_CODEC.apply(ByteBufCodecs.list((int)2)), BlockInteractingRecipe::sizedIngredients, (StreamCodec)BlockPredicate.STREAM_CODEC, BlockInteractingRecipe::blockPredicate, BlockClickingRecipe::new);

        @Override
        public MapCodec<BlockClickingRecipe> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, BlockClickingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

