/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.recipes;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.HolderSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.RecipeSerializers;
import snownee.lychee.RecipeTypes;
import snownee.lychee.context.ItemShapelessContext;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.recipes.BlockCrushingRecipeType;
import snownee.lychee.util.IngredientCollection;
import snownee.lychee.util.RecipeMatcher;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.BlockKeyableRecipe;
import snownee.lychee.util.recipe.ItemShapelessRecipeUtils;
import snownee.lychee.util.recipe.LycheeRecipe;
import snownee.lychee.util.recipe.LycheeRecipeCommonProperties;
import snownee.lychee.util.recipe.LycheeRecipeSerializer;

public class BlockCrushingRecipe
extends LycheeRecipe<LycheeContext>
implements BlockKeyableRecipe {
    public static final BlockPredicate ANVIL = BlockPredicate.Builder.block().of(BlockTags.ANVIL).build();
    protected BlockPredicate fallingBlock;
    protected BlockPredicate landingBlock;
    protected IngredientCollection ingredients;

    public BlockCrushingRecipe(LycheeRecipeCommonProperties commonProperties, BlockPredicate fallingBlock, BlockPredicate landingBlock, IngredientCollection ingredients) {
        super(commonProperties);
        this.fallingBlock = fallingBlock;
        this.landingBlock = landingBlock;
        this.ingredients = ingredients;
        this.onConstructed();
    }

    @Override
    public BlockPredicate blockPredicate() {
        return this.fallingBlock;
    }

    public BlockPredicate landingBlock() {
        return this.landingBlock;
    }

    @Override
    public boolean matches(LycheeContext context, Level level) {
        ItemShapelessContext itemShapelessContext = context.get(LycheeContextKey.ITEM_SHAPELESS);
        if (itemShapelessContext.totalItems < this.ingredients.ingredientCount()) {
            return false;
        }
        if (!BlockPredicateExtensions.isAny(this.landingBlock) && !BlockPredicateExtensions.matches(this.landingBlock, context)) {
            return false;
        }
        LootParamsContext lootParams = context.get(LycheeContextKey.LOOT_PARAMS);
        FallingBlockEntity entity = (FallingBlockEntity)lootParams.get(LootContextParams.THIS_ENTITY);
        if (!this.matchesFallingBlock(entity.getBlockState(), entity.blockData)) {
            return false;
        }
        if (this.ingredients.isEmpty()) {
            return true;
        }
        List<ItemEntity> itemEntities = itemShapelessContext.itemEntities.stream().filter($ -> this.ingredients.anyMatch($.getItem())).limit(27L).toList();
        List<ItemStack> items = itemEntities.stream().map(ItemEntity::getItem).toList();
        int[] amount = items.stream().mapToInt(ItemStack::getCount).toArray();
        Optional<RecipeMatcher<ItemStack>> match = RecipeMatcher.findMatches(items, this.ingredients.flattenedIngredients(), amount);
        if (match.isEmpty()) {
            return false;
        }
        itemShapelessContext.filteredItems = itemEntities;
        itemShapelessContext.setMatcher(match.get());
        return true;
    }

    public boolean matchesFallingBlock(BlockState blockstate, @Nullable CompoundTag nbt) {
        if (BlockPredicateExtensions.isAny(this.blockPredicate())) {
            return true;
        }
        if (this.blockPredicate().blocks().isPresent() && !blockstate.is((HolderSet)this.blockPredicate().blocks().get())) {
            return false;
        }
        if (this.blockPredicate().properties().isPresent() && !((StatePropertiesPredicate)this.blockPredicate().properties().get()).matches(blockstate)) {
            return false;
        }
        if (this.blockPredicate().nbt().isEmpty()) {
            return true;
        }
        return nbt != null && ((NbtPredicate)this.blockPredicate().nbt().get()).matches((Tag)nbt);
    }

    @Override
    public IngredientCollection ingredientCollection() {
        return this.ingredients;
    }

    @Override
    public List<BlockPredicate> getBlockInputs() {
        return (List)Util.make((Object)Lists.newArrayList((Object[])new BlockPredicate[]{this.fallingBlock}), it -> {
            if (!BlockPredicateExtensions.isAny(this.landingBlock)) {
                it.add(this.landingBlock);
            }
        });
    }

    @Override
    public LycheeRecipeSerializer<BlockCrushingRecipe> getSerializer() {
        return RecipeSerializers.BLOCK_CRUSHING;
    }

    @Override
    public BlockCrushingRecipeType getType() {
        return RecipeTypes.BLOCK_CRUSHING;
    }

    public static class Serializer
    implements LycheeRecipeSerializer<BlockCrushingRecipe> {
        public static final MapCodec<BlockCrushingRecipe> CODEC = ItemShapelessRecipeUtils.validatedCodec(RecordCodecBuilder.mapCodec(instance -> instance.group((App)LycheeRecipeCommonProperties.SIMPLE_MAP_CODEC.forGetter(LycheeRecipe::commonProperties), (App)BlockPredicateExtensions.CODEC_FOR_TESTING.optionalFieldOf("falling_block", (Object)ANVIL).forGetter(it -> it.fallingBlock), (App)BlockPredicateExtensions.CODEC_FOR_TESTING.optionalFieldOf("landing_block", (Object)BlockPredicateExtensions.ANY).forGetter(BlockCrushingRecipe::landingBlock), (App)IngredientCollection.CODEC.optionalFieldOf("item_in", (Object)IngredientCollection.EMPTY).forGetter(BlockCrushingRecipe::ingredientCollection)).apply((Applicative)instance, BlockCrushingRecipe::new)));
        public static final StreamCodec<RegistryFriendlyByteBuf, BlockCrushingRecipe> STREAM_CODEC = StreamCodec.composite(LycheeRecipeCommonProperties.STREAM_CODEC, LycheeRecipe::commonProperties, (StreamCodec)BlockPredicate.STREAM_CODEC, it -> it.fallingBlock, (StreamCodec)BlockPredicate.STREAM_CODEC, BlockCrushingRecipe::landingBlock, IngredientCollection.STREAM_CODEC, BlockCrushingRecipe::ingredientCollection, BlockCrushingRecipe::new);

        @Override
        public MapCodec<BlockCrushingRecipe> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, BlockCrushingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

