/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function3;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import snownee.kiwi.recipe.SizedIngredient;
import snownee.kiwi.util.codec.KCodecs;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.RecipeSerializers;
import snownee.lychee.RecipeTypes;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.util.BoundsExtensions;
import snownee.lychee.util.NonNullListExtensions;
import snownee.lychee.util.codec.LycheeCodecs;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.BlockKeyableRecipe;
import snownee.lychee.util.recipe.BlockKeyableRecipeType;
import snownee.lychee.util.recipe.LycheeRecipe;
import snownee.lychee.util.recipe.LycheeRecipeCommonProperties;
import snownee.lychee.util.recipe.LycheeRecipeSerializer;

public class BlockInteractingRecipe
extends LycheeRecipe<LycheeContext>
implements BlockKeyableRecipe {
    private static final Codec<SizedIngredient> OPTIONAL_SIZED_INGREDIENT_CODEC = ExtraCodecs.optionalEmptyMap(LycheeCodecs.SIZED_INGREDIENT).xmap(it -> it.orElse(SizedIngredient.EMPTY), Optional::of);
    protected final List<SizedIngredient> input;
    protected final BlockPredicate blockPredicate;

    public static InteractionResult invoke(Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (player.isSpectator()) {
            return InteractionResult.PASS;
        }
        if (hand == InteractionHand.OFF_HAND && player.getOffhandItem().isEmpty()) {
            return InteractionResult.PASS;
        }
        if (player.getCooldowns().isOnCooldown(player.getItemInHand(hand).getItem())) {
            return InteractionResult.PASS;
        }
        LycheeContext context = new LycheeContext();
        context.put(LycheeContextKey.LEVEL, level);
        LootParamsContext lootParams = context.initLootParams(RecipeTypes.BLOCK_INTERACTING);
        lootParams.set(LycheeLootContextParams.DIRECTION, hitResult.getDirection());
        Optional result = RecipeTypes.BLOCK_INTERACTING.process(player, hand, hitResult.getBlockPos(), hitResult.getLocation(), context);
        return result.map(it -> {
            player.swing(hand, true);
            return InteractionResult.SUCCESS;
        }).orElse(InteractionResult.PASS);
    }

    public BlockInteractingRecipe(LycheeRecipeCommonProperties commonProperties, List<SizedIngredient> input, BlockPredicate blockPredicate) {
        super(commonProperties);
        this.input = input;
        this.blockPredicate = blockPredicate;
        this.onConstructed();
    }

    public static <T extends BlockInteractingRecipe> MapCodec<T> codec(Function3<LycheeRecipeCommonProperties, List<SizedIngredient>, BlockPredicate, T> constructor) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)LycheeRecipeCommonProperties.mapCodec(BoundsExtensions.ONE).forGetter(LycheeRecipe::commonProperties), (App)LycheeCodecs.sizeLimit(KCodecs.compactList(OPTIONAL_SIZED_INGREDIENT_CODEC), 1, 2).fieldOf("item_in").forGetter(BlockInteractingRecipe::sizedIngredients), (App)BlockPredicateExtensions.CODEC_FOR_TESTING.optionalFieldOf("block_in", (Object)BlockPredicateExtensions.ANY).forGetter(BlockInteractingRecipe::blockPredicate)).apply((Applicative)instance, constructor));
    }

    @Override
    public List<SizedIngredient> sizedIngredients() {
        return this.input;
    }

    @Override
    public BlockPredicate blockPredicate() {
        return this.blockPredicate;
    }

    @Override
    public boolean matches(LycheeContext context, Level level) {
        return !(!this.input.getFirst().test(context.getItem(0)) || !BlockPredicateExtensions.isAny(this.blockPredicate) && !BlockPredicateExtensions.matches(this.blockPredicate, context) || this.input.size() != 1 && !this.input.getLast().test(context.getItem(1)));
    }

    @Override
    public NonNullList<Ingredient> getIngredients() {
        return NonNullListExtensions.copyOf(this.input.stream().map(SizedIngredient::ingredient).toList());
    }

    @Override
    public LycheeRecipeSerializer<? extends BlockInteractingRecipe> getSerializer() {
        return RecipeSerializers.BLOCK_INTERACTING;
    }

    @Override
    public BlockKeyableRecipeType<? extends BlockInteractingRecipe> getType() {
        return RecipeTypes.BLOCK_INTERACTING;
    }

    public static class Serializer
    implements LycheeRecipeSerializer<BlockInteractingRecipe> {
        public static MapCodec<BlockInteractingRecipe> CODEC = BlockInteractingRecipe.codec(BlockInteractingRecipe::new);
        public static final StreamCodec<RegistryFriendlyByteBuf, BlockInteractingRecipe> STREAM_CODEC = StreamCodec.composite(LycheeRecipeCommonProperties.STREAM_CODEC, LycheeRecipe::commonProperties, (StreamCodec)SizedIngredient.STREAM_CODEC.apply(ByteBufCodecs.list((int)2)), BlockInteractingRecipe::sizedIngredients, (StreamCodec)BlockPredicate.STREAM_CODEC, BlockInteractingRecipe::blockPredicate, BlockInteractingRecipe::new);

        @Override
        public MapCodec<BlockInteractingRecipe> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, BlockInteractingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

