/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.recipes;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.recipes.EntityTickingRecipe;
import snownee.lychee.util.LycheeEntity;
import snownee.lychee.util.LycheeEntityType;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.recipe.LycheeRecipeType;

public class EntityTickingRecipeType
extends LycheeRecipeType<EntityTickingRecipe> {
    private static final Set<LycheeContextKey<?>> PRESERVED_KEYS = Set.of(LycheeContextKey.LEVEL, LycheeContextKey.LOOT_PARAMS);

    public EntityTickingRecipeType(String name, Class<EntityTickingRecipe> clazz, @Nullable LootContextParamSet contextParamSet) {
        super(name, clazz, contextParamSet);
    }

    @Override
    public void refreshCache() {
        super.refreshCache();
        ArrayListMultimap map = ArrayListMultimap.create();
        for (RecipeHolder recipe : this.recipes) {
            ((EntityTickingRecipe)recipe.value()).predicate().entityType().map($ -> $.types().stream()).orElseGet(Stream::empty).forEach(arg_0 -> EntityTickingRecipeType.lambda$refreshCache$1((ListMultimap)map, recipe, arg_0));
        }
        for (EntityType type : BuiltInRegistries.ENTITY_TYPE) {
            ((LycheeEntityType)type).lychee$setTickingRecipes((ImmutableList<RecipeHolder<EntityTickingRecipe>>)ImmutableList.copyOf((Collection)map.get((Object)type)));
        }
    }

    public void process(Entity entity, List<RecipeHolder<EntityTickingRecipe>> recipes) {
        LootParamsContext lootParams;
        if (recipes.isEmpty() || entity.level().isClientSide) {
            return;
        }
        ServerLevel level = (ServerLevel)entity.level();
        LycheeEntity lycheeEntity = (LycheeEntity)entity;
        LycheeContext context = lycheeEntity.lychee$getContext();
        if (context == null) {
            context = new LycheeContext();
            context.put(LycheeContextKey.LEVEL, level);
            lycheeEntity.lychee$setContext(context);
            lootParams = context.initLootParams(this);
        } else {
            lootParams = context.get(LycheeContextKey.LOOT_PARAMS);
        }
        lootParams.set(LootContextParams.THIS_ENTITY, entity);
        lootParams.set(LootContextParams.ORIGIN, entity.position());
        lootParams.validate();
        for (RecipeHolder<EntityTickingRecipe> recipeHolder : recipes) {
            EntityTickingRecipe recipe = (EntityTickingRecipe)recipeHolder.value();
            if (recipe.interval() > 1 && (entity.tickCount + 1) % recipe.interval() != 0 || !recipe.withoutTypePredicate().matches(level, entity.position(), entity) || recipe.test(recipe, context, 1) <= 0 || !recipe.matches(context, (Level)level)) continue;
            context.put(recipeHolder);
            recipe.applyPostActions(context, 1);
            boolean avoidDefault = context.get(LycheeContextKey.ACTION).avoidDefault;
            context.removeAllExcept(PRESERVED_KEYS);
            if (!avoidDefault) continue;
            break;
        }
    }

    private static /* synthetic */ void lambda$refreshCache$1(ListMultimap map, RecipeHolder recipe, Holder type) {
        map.put((Object)((EntityType)type.value()), (Object)recipe);
    }
}

