/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.Level;
import snownee.lychee.RecipeSerializers;
import snownee.lychee.RecipeTypes;
import snownee.lychee.recipes.RandomBlockTickingRecipeType;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.BlockKeyableRecipe;
import snownee.lychee.util.recipe.ChanceRecipe;
import snownee.lychee.util.recipe.LycheeRecipe;
import snownee.lychee.util.recipe.LycheeRecipeCommonProperties;
import snownee.lychee.util.recipe.LycheeRecipeSerializer;

public class RandomBlockTickingRecipe
extends LycheeRecipe<LycheeContext>
implements BlockKeyableRecipe,
ChanceRecipe {
    protected float chance = 1.0f;
    protected final BlockPredicate blockPredicate;

    public RandomBlockTickingRecipe(LycheeRecipeCommonProperties commonProperties, BlockPredicate blockPredicate) {
        super(commonProperties);
        this.blockPredicate = blockPredicate;
        this.onConstructed();
    }

    @Override
    public BlockPredicate blockPredicate() {
        return this.blockPredicate;
    }

    @Override
    public void setChance(float chance) {
        this.chance = chance;
    }

    @Override
    public float getChance() {
        return this.chance;
    }

    @Override
    public boolean matches(LycheeContext context, Level level) {
        return BlockPredicateExtensions.matches(this.blockPredicate, context);
    }

    @Override
    public LycheeRecipeSerializer<RandomBlockTickingRecipe> getSerializer() {
        return RecipeSerializers.RANDOM_BLOCK_TICKING;
    }

    @Override
    public RandomBlockTickingRecipeType getType() {
        return RecipeTypes.RANDOM_BLOCK_TICKING;
    }

    public static class Serializer
    implements LycheeRecipeSerializer<RandomBlockTickingRecipe> {
        public static final MapCodec<RandomBlockTickingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LycheeRecipeCommonProperties.SIMPLE_MAP_CODEC.forGetter(LycheeRecipe::commonProperties), (App)BlockPredicateExtensions.CODEC_FOR_TESTING.optionalFieldOf("block_in", (Object)BlockPredicateExtensions.ANY).forGetter(RandomBlockTickingRecipe::blockPredicate)).apply((Applicative)instance, RandomBlockTickingRecipe::new)).validate(it -> {
            if (!it.ghost() && BlockPredicateExtensions.isAny(it.blockPredicate())) {
                return DataResult.error(() -> "Wildcard block input is not allowed for this recipe type.");
            }
            return DataResult.success((Object)it);
        });
        public static final StreamCodec<RegistryFriendlyByteBuf, RandomBlockTickingRecipe> STREAM_CODEC = StreamCodec.composite(LycheeRecipeCommonProperties.STREAM_CODEC, LycheeRecipe::commonProperties, (StreamCodec)BlockPredicate.STREAM_CODEC, RandomBlockTickingRecipe::blockPredicate, RandomBlockTickingRecipe::new);

        @Override
        public MapCodec<RandomBlockTickingRecipe> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, RandomBlockTickingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

