/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.ui;

import java.util.function.Function;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3fc;
import snownee.lychee.client.gui.GuiGameElement;
import snownee.lychee.client.gui.RenderElement;
import snownee.lychee.ui.GameElement;
import snownee.lychee.ui.GameElementProperties;

@FunctionalInterface
public interface GameElementRenderer<T extends GameElement>
extends Function<T, RenderElement> {
    @Override
    default public RenderElement apply(T element) {
        GameElementProperties properties = element.gameProperties();
        Vector3fc localPos = properties.localPos();
        Vector3fc rotationOffset = properties.rotationOffset();
        Vector3fc rotation = properties.rotation();
        return this.decorated(element).atLocal(localPos.x(), localPos.y(), localPos.z()).withRotationOffset(new Vec3((double)rotationOffset.x(), (double)rotationOffset.y(), (double)rotationOffset.z())).rotate(rotation.x(), rotation.y(), rotation.z()).scale(properties.scale());
    }

    public GuiGameElement.GuiRenderBuilder decorated(T var1);
}

