/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.ui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import snownee.lychee.client.gui.RenderElement;
import snownee.lychee.ui.TextElement;

public class TextElementRenderer
extends RenderElement {
    public final Component text;
    public final Component darkText;
    public Font font;
    public int lightModeColor = -10066330;
    public int darkModeColor = -4473925;
    public boolean shadow;
    public boolean centered;

    public TextElementRenderer(Component text) {
        this(text, text);
    }

    public TextElementRenderer(Component text, Component darkText) {
        this.text = text;
        this.darkText = darkText;
        this.font = Minecraft.getInstance().font;
        this.shadow = false;
    }

    public TextElementRenderer font(Font font) {
        this.font = font;
        return this;
    }

    public TextElementRenderer color(int lightModeColor, int darkModeColor) {
        this.lightModeColor = lightModeColor;
        this.darkModeColor = darkModeColor;
        return this;
    }

    public TextElementRenderer shadow() {
        this.shadow = true;
        return this;
    }

    public TextElementRenderer centered() {
        this.centered = true;
        return this;
    }

    @Override
    public void render(GuiGraphics graphics) {
        if (!this.centered) {
            graphics.drawString(this.font, this.text, (int)this.x(), (int)this.y(), this.lightModeColor, this.shadow);
        } else {
            graphics.drawString(this.font, this.text, (int)(this.x() - (float)this.font.width((FormattedText)this.text) / 2.0f), (int)this.y(), this.lightModeColor, this.shadow);
        }
    }

    public static TextElementRenderer create(TextElement element) {
        TextElementRenderer renderer = new TextElementRenderer(element.text(), element.darkText().orElse(element.text())).color(element.color(), element.darkColor());
        if (element.centered()) {
            renderer.centered();
        }
        if (element.shadow()) {
            renderer.shadow();
        }
        return renderer;
    }
}

