/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util;

import com.mojang.blaze3d.platform.InputConstants;
import java.text.MessageFormat;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.util.KEvent;
import snownee.lychee.client.gui.InteractiveRenderElement;
import snownee.lychee.util.action.ActionRenderer;
import snownee.lychee.util.particles.dripstone.DripstoneParticleService;
import snownee.lychee.util.particles.dripstone.client.ParticleFactories;
import snownee.lychee.util.ui.ElementRenderer;
import snownee.lychee.util.ui.InputAction;

@Mod(value="lychee", dist={Dist.CLIENT})
public class ClientProxy {
    public static final boolean HAS_PONDER = ModList.get().isLoaded("ponder");
    private static final KEvent<RecipeViewerWidgetInputListener> RECIPE_VIEWER_WIDGET_INPUT_EVENT = KEvent.createArrayBacked(RecipeViewerWidgetInputListener.class, listeners -> (recipe, location, action) -> {
        for (RecipeViewerWidgetInputListener listener : listeners) {
            if (!listener.on(recipe, location, action)) continue;
            return true;
        }
        return false;
    });
    public static boolean hasJade = Platform.isModLoaded((String)"jade");

    public static MutableComponent format(String s, Object ... objects) {
        try {
            return Component.literal((String)MessageFormat.format(I18n.get((String)s, (Object[])new Object[0]), objects));
        }
        catch (Exception e) {
            return Component.translatable((String)s, (Object[])objects);
        }
    }

    public static void registerWidgetInputListener(RecipeViewerWidgetInputListener listener) {
        RECIPE_VIEWER_WIDGET_INPUT_EVENT.register((Object)listener);
    }

    public static boolean postWidgetInputEvent(Recipe<?> recipe, String id, InputAction action, @Nullable InteractiveRenderElement element) {
        return action.isMouseOver(element) && ((RecipeViewerWidgetInputListener)RECIPE_VIEWER_WIDGET_INPUT_EVENT.invoker()).on(recipe, id, action);
    }

    public static Component getFluidName(Fluid fluid) {
        return fluid.getFluidType().getDescription();
    }

    public static InputConstants.Key getKeyMapping(InputAction action) {
        if (action instanceof InputAction.MousePressed) {
            InputAction.MousePressed mousePressed = (InputAction.MousePressed)action;
            return InputConstants.Type.MOUSE.getOrCreate(mousePressed.button);
        }
        if (action instanceof InputAction.KeyPressed) {
            InputAction.KeyPressed keyPressed = (InputAction.KeyPressed)action;
            return InputConstants.getKey((int)keyPressed.keyCode, (int)keyPressed.scanCode);
        }
        return InputConstants.UNKNOWN;
    }

    public ClientProxy(IEventBus modEventBus) {
        ParticleFactoryRegistry.getInstance().register(DripstoneParticleService.DRIPSTONE_DRIPPING, ParticleFactories.Dripping::new);
        ParticleFactoryRegistry.getInstance().register(DripstoneParticleService.DRIPSTONE_FALLING, ParticleFactories.Falling::new);
        ParticleFactoryRegistry.getInstance().register(DripstoneParticleService.DRIPSTONE_SPLASH, ParticleFactories.Splash::new);
        ActionRenderer.init();
        ElementRenderer.init();
    }

    @FunctionalInterface
    public static interface RecipeViewerWidgetInputListener {
        public boolean on(Recipe<?> var1, String var2, InputAction var3);
    }
}

