/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.recipe.CustomIngredientSerializer;
import snownee.kiwi.util.KEvent;
import snownee.kiwi.util.KUtil;
import snownee.lychee.Lychee;
import snownee.lychee.LycheeRegistries;
import snownee.lychee.RecipeSerializers;
import snownee.lychee.RecipeTypes;
import snownee.lychee.action.CustomAction;
import snownee.lychee.compat.recipe_api.AlwaysTrueIngredient;
import snownee.lychee.compat.recipe_api.VisualOnlyComponentsIngredient;
import snownee.lychee.compat.recipeviewer.IngredientType;
import snownee.lychee.contextual.CustomCondition;
import snownee.lychee.recipes.BlockClickingRecipe;
import snownee.lychee.recipes.BlockInteractingRecipe;
import snownee.lychee.util.action.PostActionTypes;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.context.LycheeContextSerializers;
import snownee.lychee.util.contextual.ContextualConditionType;
import snownee.lychee.util.particles.dripstone.DripstoneParticleService;
import snownee.lychee.util.recipe.ILycheeRecipe;
import snownee.lychee.util.ui.UIElementType;

@Mod(value="lychee")
public class CommonProxy {
    public static final KEvent<CustomActionListener> CUSTOM_ACTION_EVENT = KEvent.createArrayBacked(CustomActionListener.class, listeners -> (id, action, recipe) -> {
        for (CustomActionListener listener : listeners) {
            if (!listener.on(id, action, recipe)) continue;
            return true;
        }
        return false;
    });
    public static final KEvent<CustomConditionListener> CUSTOM_CONDITION_EVENT = KEvent.createArrayBacked(CustomConditionListener.class, listeners -> (id, condition) -> {
        for (CustomConditionListener listener : listeners) {
            if (!listener.on(id, condition)) continue;
            return true;
        }
        return false;
    });
    private static final Random RANDOM = new Random();
    public static boolean hasDFLib = Platform.isModLoaded((String)"dripstone_fluid_lib");

    public static void dropItemStack(Level pLevel, double pX, double pY, double pZ, ItemStack pStack, @Nullable Consumer<ItemEntity> extraStep) {
        while (!pStack.isEmpty()) {
            ItemEntity itementity = new ItemEntity(pLevel, pX, pY, pZ, pStack.split(Math.min(RANDOM.nextInt(21) + 10, pStack.getMaxStackSize())));
            itementity.setDeltaMovement(RANDOM.nextGaussian() * 0.05 - 0.025, RANDOM.nextGaussian() * 0.05 + 0.2, RANDOM.nextGaussian() * 0.05 - 0.025);
            if (extraStep != null) {
                extraStep.accept(itementity);
            }
            pLevel.addFreshEntity((Entity)itementity);
        }
    }

    public static String makeDescriptionId(String pType, @Nullable ResourceLocation pId) {
        return pId == null ? pType + ".unregistered_sadface" : pType + "." + CommonProxy.wrapNamespace(pId.getNamespace()) + "." + pId.getPath().replace('/', '.');
    }

    public static String wrapNamespace(String modid) {
        return "minecraft".equals(modid) ? "lychee" : modid;
    }

    public static MutableComponent white(CharSequence s) {
        return Component.literal((String)s.toString()).withStyle(ChatFormatting.WHITE);
    }

    public static String chance(float chance) {
        if (chance >= 0.1f) {
            return (int)(chance * 100.0f) + "%";
        }
        if (chance >= 0.001f) {
            return String.format("%.1f%%", Float.valueOf(chance * 100.0f));
        }
        return "<0.1%";
    }

    public static String capitaliseAllWords(String str) {
        int sz = str.length();
        StringBuilder buffer = new StringBuilder(sz);
        boolean space = true;
        for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (Character.isWhitespace(ch)) {
                buffer.append(ch);
                space = true;
                continue;
            }
            if (space) {
                buffer.append(Character.toTitleCase(ch));
                space = false;
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static <T> T getCycledItem(List<T> list, T fallback, int interval) {
        if (list.isEmpty()) {
            return fallback;
        }
        if (list.size() == 1) {
            return list.getFirst();
        }
        long index = System.currentTimeMillis() / (long)interval % (long)list.size();
        return list.get(Math.toIntExact(index));
    }

    @Nullable
    public static RecipeHolder<?> recipe(ResourceLocation id) {
        RecipeManager manager = KUtil.getRecipeManager();
        if (manager == null) {
            return null;
        }
        return manager.byKey(id).orElse(null);
    }

    public static BlockPos getOnPos(Entity entity) {
        int i = Mth.floor((double)entity.getX());
        int j = Mth.floor((double)(entity.getY() - 0.05));
        int k = Mth.floor((double)entity.getZ());
        BlockPos blockpos = new BlockPos(i, j, k);
        if (entity.level().isEmptyBlock(blockpos)) {
            BlockPos blockpos1 = blockpos.below();
            BlockState blockstate = entity.level().getBlockState(blockpos1);
            if (CommonProxy.collisionExtendsVertically(blockstate, entity.level(), blockpos1, entity)) {
                return blockpos1;
            }
        }
        return blockpos;
    }

    public static boolean collisionExtendsVertically(BlockState state, Level level, BlockPos pos, Entity entity) {
        return state.is(BlockTags.FENCES) || state.is(BlockTags.WALLS) || state.getBlock() instanceof FenceGateBlock;
    }

    public static Vec3 clampPos(Vec3 origin, BlockPos pos) {
        double x = CommonProxy.clamp(origin.x, pos.getX());
        double y = CommonProxy.clamp(origin.y, pos.getY());
        double z = CommonProxy.clamp(origin.z, pos.getZ());
        if (x == origin.x && y == origin.y && z == origin.z) {
            return origin;
        }
        return new Vec3(x, y, z);
    }

    private static double clamp(double v, int target) {
        if (v < (double)target) {
            return target;
        }
        if (v >= (double)(target + 1)) {
            return (double)target + 0.999999;
        }
        return v;
    }

    public static boolean isSimpleIngredient(Ingredient ingredient) {
        return ingredient.isSimple();
    }

    public static JsonObject tagToJson(CompoundTag tag) {
        return ((JsonElement)NbtOps.INSTANCE.convertTo((DynamicOps)JsonOps.INSTANCE, (Tag)tag)).getAsJsonObject();
    }

    public static CompoundTag jsonToTag(JsonElement json) {
        if (json.isJsonObject()) {
            return (CompoundTag)JsonOps.INSTANCE.convertTo((DynamicOps)NbtOps.INSTANCE, json);
        }
        try {
            return TagParser.parseTag((String)json.getAsString());
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void registerCustomActionListener(CustomActionListener listener) {
        CUSTOM_ACTION_EVENT.register((Object)listener);
    }

    public static void registerCustomConditionListener(CustomConditionListener listener) {
        CUSTOM_CONDITION_EVENT.register((Object)listener);
    }

    public static void postCustomActionEvent(String id, CustomAction action, ILycheeRecipe<?> recipe) {
        ((CustomActionListener)CUSTOM_ACTION_EVENT.invoker()).on(id, action, recipe);
    }

    public static void postCustomConditionEvent(String id, CustomCondition condition) {
        ((CustomConditionListener)CUSTOM_CONDITION_EVENT.invoker()).on(id, condition);
    }

    public static IngredientType getIngredientType(Ingredient ingredient) {
        ICustomIngredient customIngredient = ingredient.getCustomIngredient();
        if (customIngredient != null && Objects.equals(NeoForgeRegistries.INGREDIENT_TYPES.getKey((Object)customIngredient.getType()), AlwaysTrueIngredient.ID)) {
            return IngredientType.ANY;
        }
        if (ingredient.isEmpty()) {
            return IngredientType.AIR;
        }
        return IngredientType.NORMAL;
    }

    public static boolean dispensePlacement(BlockSource pSource, ItemStack pStack, Direction direction) {
        Item item = pStack.getItem();
        if (!(item instanceof BlockItem)) {
            return false;
        }
        BlockItem item2 = (BlockItem)item;
        BlockPos blockpos = pSource.pos().relative(direction);
        BlockState state = pSource.level().getBlockState(blockpos);
        if (!FallingBlock.isFree((BlockState)state)) {
            return false;
        }
        Block block = item2.getBlock();
        if (block instanceof PointedDripstoneBlock) {
            PointedDripstoneBlock block2 = (PointedDripstoneBlock)block;
            BlockState blockState = (BlockState)block2.defaultBlockState().setValue((Property)PointedDripstoneBlock.TIP_DIRECTION, (Comparable)Direction.DOWN);
            FallingBlockEntity entity = FallingBlockEntity.fall((Level)pSource.level(), (BlockPos)blockpos, (BlockState)blockState);
            float f = 6.0f;
            entity.setHurtsEntities(f, 40);
            pStack.shrink(1);
            return true;
        }
        try {
            item2.place((BlockPlaceContext)new DirectionalPlaceContext((Level)pSource.level(), blockpos, direction, pStack, direction));
        }
        catch (Exception exception) {
            Lychee.LOGGER.error("Error trying to place block at {}", (Object)blockpos, (Object)exception);
        }
        return false;
    }

    public static <T> String getTagTranslationKey(TagKey<T> key) {
        return Tags.getTagTranslationKey(key);
    }

    public CommonProxy(IEventBus modEventBus) {
        CustomIngredientSerializer.register(AlwaysTrueIngredient.SERIALIZER);
        CustomIngredientSerializer.register(VisualOnlyComponentsIngredient.SERIALIZER);
        modEventBus.addListener(LycheeRegistries::init);
        modEventBus.addListener(CommonProxy::register);
        NeoForge.EVENT_BUS.addListener(event -> {
            InteractionResult result = BlockInteractingRecipe.invoke(event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec());
            event.setCanceled(result.consumesAction());
            event.setCancellationResult(result);
        });
        NeoForge.EVENT_BUS.addListener(event -> {
            InteractionResult result = BlockClickingRecipe.invoke(event.getEntity(), event.getLevel(), event.getHand(), event.getPos(), event.getFace());
            event.setCanceled(result.consumesAction());
        });
    }

    private static void register(RegisterEvent event) {
        event.register(LycheeRegistries.CONTEXT.key(), helper -> Objects.requireNonNull(LycheeContextKey.ACTION));
        event.register(LycheeRegistries.CONTEXT_SERIALIZER.key(), helper -> LycheeContextSerializers.init());
        event.register(LycheeRegistries.CONTEXTUAL.key(), helper -> Objects.requireNonNull(ContextualConditionType.AND));
        event.register(LycheeRegistries.POST_ACTION.key(), helper -> Objects.requireNonNull(PostActionTypes.DROP_ITEM));
        event.register(BuiltInRegistries.RECIPE_SERIALIZER.key(), helper -> Objects.requireNonNull(RecipeSerializers.ITEM_BURNING));
        event.register(BuiltInRegistries.RECIPE_TYPE.key(), helper -> Objects.requireNonNull(RecipeTypes.ALL));
        event.register(BuiltInRegistries.PARTICLE_TYPE.key(), helper -> {
            Registry.register((Registry)BuiltInRegistries.PARTICLE_TYPE, (ResourceLocation)Lychee.id("dripstone_dripping"), DripstoneParticleService.DRIPSTONE_DRIPPING);
            Registry.register((Registry)BuiltInRegistries.PARTICLE_TYPE, (ResourceLocation)Lychee.id("dripstone_falling"), DripstoneParticleService.DRIPSTONE_FALLING);
            Registry.register((Registry)BuiltInRegistries.PARTICLE_TYPE, (ResourceLocation)Lychee.id("dripstone_splash"), DripstoneParticleService.DRIPSTONE_SPLASH);
        });
        event.register(LycheeRegistries.UI_ELEMENT.key(), helper -> Objects.requireNonNull(UIElementType.BLOCK));
    }

    public static interface CustomActionListener {
        public boolean on(String var1, CustomAction var2, ILycheeRecipe<?> var3);
    }

    public static interface CustomConditionListener {
        public boolean on(String var1, CustomCondition var2);
    }
}

