/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import snownee.kiwi.recipe.SizedIngredient;
import snownee.kiwi.util.codec.KCodecs;
import snownee.lychee.util.NonNullListExtensions;
import snownee.lychee.util.codec.LycheeCodecs;

public final class IngredientCollection {
    public static final IngredientCollection EMPTY = new IngredientCollection(List.of());
    public static final Codec<IngredientCollection> CODEC = KCodecs.compactList(LycheeCodecs.SIZED_INGREDIENT).xmap(IngredientCollection::new, IngredientCollection::ingredients);
    public static final StreamCodec<RegistryFriendlyByteBuf, IngredientCollection> STREAM_CODEC = StreamCodec.composite((StreamCodec)SizedIngredient.STREAM_CODEC.apply(ByteBufCodecs.list()), IngredientCollection::ingredients, IngredientCollection::of);
    private final List<SizedIngredient> ingredients;
    private final int ingredientCount;
    private NonNullList<Ingredient> flattenedIngredients;

    public static Codec<IngredientCollection> codec(int minSize, int maxSize) {
        return LycheeCodecs.sizeLimit(KCodecs.compactList(LycheeCodecs.SIZED_INGREDIENT), minSize, maxSize).xmap(IngredientCollection::of, IngredientCollection::ingredients);
    }

    public static IngredientCollection of(List<SizedIngredient> ingredients) {
        if (ingredients.isEmpty()) {
            return EMPTY;
        }
        return new IngredientCollection(ingredients);
    }

    public IngredientCollection(List<SizedIngredient> ingredients) {
        this.ingredients = ingredients;
        this.ingredientCount = ingredients.stream().mapToInt(SizedIngredient::count).sum();
    }

    public List<SizedIngredient> ingredients() {
        return this.ingredients;
    }

    public int size() {
        return this.ingredients.size();
    }

    public boolean isEmpty() {
        return this.ingredients.isEmpty();
    }

    public int ingredientCount() {
        return this.ingredientCount;
    }

    public NonNullList<Ingredient> flattenedIngredients() {
        if (this.flattenedIngredients == null) {
            ArrayList list = Lists.newArrayListWithExpectedSize((int)this.ingredientCount);
            for (SizedIngredient ingredient : this.ingredients) {
                for (int i = 0; i < ingredient.count(); ++i) {
                    list.add(ingredient.ingredient());
                }
            }
            this.flattenedIngredients = NonNullListExtensions.copyOf(list);
        }
        return this.flattenedIngredients;
    }

    public boolean anyMatch(ItemStack itemStack) {
        for (SizedIngredient ingredient : this.ingredients) {
            if (!ingredient.ingredient().test(itemStack)) continue;
            return true;
        }
        return false;
    }
}

