/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.util.codec.KCodecs;
import snownee.lychee.Lychee;

public class Patterns
implements Predicate<String> {
    public static final Codec<Patterns> CODEC = ExtraCodecs.nonEmptyList((Codec)KCodecs.compactList((Codec)ExtraCodecs.NON_EMPTY_STRING)).xmap(Patterns::new, Patterns::strings);
    public static final StreamCodec<ByteBuf, Patterns> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()).map(Patterns::new, Patterns::strings);
    public static final Patterns EMPTY = new Patterns(List.of());
    private final List<String> strings;
    @Nullable
    private List<Pattern> patterns;

    public Patterns(List<String> strings) {
        this.strings = strings;
    }

    public List<String> strings() {
        return this.strings;
    }

    public List<Pattern> patterns() {
        if (this.patterns == null) {
            this.patterns = this.strings.stream().map(it -> {
                try {
                    return Pattern.compile(it);
                }
                catch (Exception e) {
                    Lychee.LOGGER.error("Failed to compile pattern: {}", it);
                    return null;
                }
            }).filter(Objects::nonNull).toList();
        }
        return this.patterns;
    }

    @Override
    public boolean test(String s) {
        if (this.strings.isEmpty()) {
            return false;
        }
        for (Pattern pattern : this.patterns()) {
            if (!pattern.matcher(s).matches()) continue;
            return true;
        }
        return false;
    }
}

