/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import snownee.lychee.util.json.JsonPointer;

public abstract class Reference {
    public static final Codec<Reference> CODEC = ExtraCodecs.NON_EMPTY_STRING.xmap(Reference::create, Object::toString);
    public static final StreamCodec<ByteBuf, Reference> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(Reference::create, Object::toString);
    public static final Reference DEFAULT = new Constant("default");

    public static Reference create(String value) {
        if ("default".equals(value)) {
            return DEFAULT;
        }
        if (value.codePointAt(0) == 47) {
            return new Pointer(new JsonPointer(value));
        }
        return new Constant(value);
    }

    public boolean isPointer() {
        return this.getClass() == Pointer.class;
    }

    public JsonPointer getPointer() {
        return ((Pointer)this).pointer;
    }

    public static class Pointer
    extends Reference {
        private final JsonPointer pointer;

        public Pointer(JsonPointer pointer) {
            this.pointer = pointer;
        }

        public String toString() {
            return this.pointer.toString();
        }
    }

    public static class Constant
    extends Reference {
        public final String name;

        public Constant(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

