/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VectorExtensions {
    public static final Vector2fc ZERO2F = new Vector2f();
    public static final Vector3fc ZERO3F = new Vector3f();
    public static final Codec<Vector3fc> CODEC3F = Codec.FLOAT.listOf(2, 3).xmap(list -> new Vector3f(((Float)list.get(0)).floatValue(), ((Float)list.get(1)).floatValue(), list.size() == 3 ? ((Float)list.get(2)).floatValue() : 0.0f), vector -> List.of(Float.valueOf(vector.x()), Float.valueOf(vector.y()), Float.valueOf(vector.z())));
    public static final StreamCodec<ByteBuf, Vector3fc> STREAM_CODEC3F = ByteBufCodecs.VECTOR3F.map(Vector3f::absolute, Vector3f::new);
    public static final Codec<Vector2ic> CODEC2I = Codec.INT.listOf(1, 2).xmap(list -> new Vector2i(((Integer)list.getFirst()).intValue(), (list.size() == 1 ? (Integer)list.getFirst() : (Integer)list.getLast()).intValue()), vector -> List.of(Integer.valueOf(vector.x()), Integer.valueOf(vector.y())));
    public static final StreamCodec<ByteBuf, Vector2ic> STREAM_CODEC2I = ByteBufCodecs.VAR_INT.apply(ByteBufCodecs.list((int)2)).map(list -> new Vector2i(((Integer)list.getFirst()).intValue(), ((Integer)list.getLast()).intValue()), vector -> List.of(Integer.valueOf(vector.x()), Integer.valueOf(vector.y())));

    public static Vector2f offset(Vector2fc vector, float x, float y) {
        return new Vector2f(vector.x() + x, vector.y() + y);
    }

    public static Vector2f offset(Vector2fc vector, Vector2f other) {
        return new Vector2f(vector.x() + other.x(), vector.y() + other.y());
    }

    public static Vector2f offsetX(Vector2fc vector, float x) {
        return new Vector2f(vector.x() + x, vector.y());
    }

    public static Vector2f offsetY(Vector2fc vector, float y) {
        return new Vector2f(vector.x(), vector.y() + y);
    }

    public static Vector2f withX(Vector2fc vector, float x) {
        return new Vector2f(x, vector.y());
    }
}

