/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.codec;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class AliasOptionalFieldCodec<A>
extends MapCodec<Optional<A>> {
    private final String name;
    private final Codec<A> elementCodec;
    private final boolean lenient;
    private final String alias;

    public AliasOptionalFieldCodec(String name, Codec<A> elementCodec, boolean lenient, String alias) {
        this.name = name;
        this.elementCodec = elementCodec;
        this.lenient = lenient;
        this.alias = alias;
    }

    public static <A> MapCodec<A> defaulted(String name, Codec<A> elementCodec, A defaultValue, String alias) {
        return new AliasOptionalFieldCodec<A>(name, elementCodec, false, alias).xmap(o -> o.orElse(defaultValue), a -> Objects.equals(a, defaultValue) ? Optional.empty() : Optional.of(a));
    }

    public <T> DataResult<Optional<A>> decode(DynamicOps<T> ops, MapLike<T> input) {
        return input.get(this.name) != null ? this.decodeAs(ops, input, this.name) : this.decodeAs(ops, input, this.alias);
    }

    public <T> DataResult<Optional<A>> decodeAs(DynamicOps<T> ops, MapLike<T> input, String name) {
        Object value = input.get(name);
        if (value == null) {
            return DataResult.success(Optional.empty());
        }
        DataResult parsed = this.elementCodec.parse(ops, value);
        if (parsed.isError() && this.lenient) {
            return DataResult.success(Optional.empty());
        }
        return parsed.map(Optional::of).setPartial((Object)parsed.resultOrPartial());
    }

    public <T> RecordBuilder<T> encode(Optional<A> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        if (input.isPresent()) {
            return prefix.add(this.name, this.elementCodec.encodeStart(ops, input.get()));
        }
        return prefix;
    }

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return Stream.of(ops.createString(this.name));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AliasOptionalFieldCodec that = (AliasOptionalFieldCodec)((Object)o);
        return this.lenient == that.lenient && this.name.equals(that.name) && this.elementCodec.equals(that.elementCodec) && this.alias.equals(that.alias);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.elementCodec, this.lenient, this.alias);
    }

    public String toString() {
        return "AliasOptionalFieldCodec[%s(%s): %s]".formatted(this.name, this.alias, this.elementCodec);
    }
}

