/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.codec;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class KeyDispatchedMapMapCodec<K, V>
extends MapCodec<Map<K, V>> {
    private final Codec<K> keyCodec;
    private final Function<? super K, ? extends DataResult<? extends Decoder<? extends V>>> decoder;
    private final Function<? super K, ? extends DataResult<? extends Encoder<V>>> encoder;
    private final Keyable keys;
    private final Supplier<Map<K, V>> mapFactory;

    public KeyDispatchedMapMapCodec(Codec<K> keyCodec, Function<? super K, ? extends DataResult<? extends Decoder<? extends V>>> decoder, Function<? super K, ? extends DataResult<? extends Encoder<V>>> encoder, Keyable keys, Supplier<Map<K, V>> mapFactory) {
        this.keyCodec = keyCodec;
        this.decoder = decoder;
        this.encoder = encoder;
        this.keys = keys;
        this.mapFactory = mapFactory;
    }

    public KeyDispatchedMapMapCodec(Codec<K> keyCodec, Function<? super K, DataResult<Codec<V>>> codec, Keyable keys, Supplier<Map<K, V>> mapFactory) {
        this(keyCodec, codec, codec, keys, mapFactory);
    }

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return this.keys.keys(ops);
    }

    private static <K, V> DataResult<? extends Encoder<V>> getCodec(Function<? super V, ? extends DataResult<? extends K>> type, Function<? super K, ? extends DataResult<? extends Encoder<? extends V>>> encoder, V input) {
        return type.apply(input).flatMap(k -> ((DataResult)encoder.apply((Object)k)).map(Function.identity())).map(c -> c);
    }

    public <T> DataResult<Map<K, V>> decode(DynamicOps<T> ops, MapLike<T> input) {
        Map elements = this.mapFactory.get();
        ImmutableList.Builder failed = ImmutableList.builder();
        DataResult result = this.keys(ops).reduce(DataResult.success((Object)Unit.INSTANCE, (Lifecycle)Lifecycle.stable()), (r, key) -> {
            DataResult parsedKey = this.keyCodec.parse(ops, key);
            Object rawValue = input.get(key);
            if (rawValue == null) {
                return r;
            }
            DataResult valueResult = ((Decoder)this.decoder.apply(parsedKey.getOrThrow(err -> new IllegalStateException(String.format("Failed get key from %s", key)))).getOrThrow(err -> new IllegalStateException(String.format("Failed get codec for %s", rawValue)))).parse(ops, rawValue);
            DataResult entry = parsedKey.apply2stable(Pair::of, valueResult);
            entry.error().ifPresent(e -> failed.add(key));
            return r.apply2stable((u, p) -> {
                elements.put(p.getFirst(), p.getSecond());
                return u;
            }, entry);
        }, (r1, r2) -> r1.apply2stable((u1, u2) -> u1, r2));
        Object errors = ops.createList(failed.build().stream());
        return result.map(unit -> elements).setPartial(elements).mapError(e -> e + " missed input: " + String.valueOf(errors));
    }

    public <T> RecordBuilder<T> encode(Map<K, V> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        this.keys.keys(ops).forEach(key -> {
            DataResult parsedKeyResult = this.keyCodec.parse(ops, key);
            Object parsedKey = parsedKeyResult.getOrThrow(err -> new IllegalStateException(String.format("Failed get key from %s", key)));
            if (!input.containsKey(parsedKey)) {
                return;
            }
            Object value = input.get(parsedKey);
            prefix.add(key, ((Encoder)this.encoder.apply(parsedKey).getOrThrow(err -> new IllegalStateException(String.format("Failed get codec for %s", key)))).encodeStart(ops, value));
        });
        return prefix;
    }

    public String toString() {
        return "KeyDispatchMapCodec[" + this.keyCodec.toString() + " " + String.valueOf(this.decoder) + "]";
    }
}

