/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.codec;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.StringReader;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import snownee.kiwi.recipe.SizedIngredient;
import snownee.lychee.util.codec.ParsedItem;
import snownee.lychee.util.codec.ThrowingSupplier;

public final class LycheeCodecs {
    private static final MapCodec<Integer> ITEM_STACK_COUNT = ExtraCodecs.NON_NEGATIVE_INT.fieldOf("count").orElse((Object)1);
    private static final MapCodec<ItemStack> ITEM_STACK_MAP_ENCODER = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.ITEM.holderByNameCodec().fieldOf("id").forGetter(ItemStack::getItemHolder), (App)ITEM_STACK_COUNT.forGetter(ItemStack::getCount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(ItemStack::getComponentsPatch)).apply((Applicative)instance, ItemStack::new));
    public static final MapCodec<ItemStack> ITEM_STACK_MAP_CODEC = MapCodec.of(ITEM_STACK_MAP_ENCODER, (MapDecoder)new MapDecoder.Implementation<ItemStack>(){

        public <T> DataResult<ItemStack> decode(DynamicOps<T> ops, MapLike<T> input) {
            ItemParser.ItemResult itemResult;
            DataResult result = ITEM_STACK_MAP_ENCODER.decode(ops, input);
            if (result.isSuccess()) {
                return result;
            }
            Object id = input.get("id");
            if (id == null) {
                return DataResult.error(() -> "Missing id");
            }
            if (!(ops instanceof RegistryOps)) {
                return DataResult.error(() -> "Not a registry ops");
            }
            final RegistryOps registryOps = (RegistryOps)ops;
            ItemParser parser = new ItemParser(new HolderLookup.Provider(){

                public Stream<ResourceKey<? extends Registry<?>>> listRegistries() {
                    throw new IllegalStateException();
                }

                public <R> Optional<HolderLookup.RegistryLookup<R>> lookup(ResourceKey<? extends Registry<? extends R>> resourceKey) {
                    return Optional.of(BuiltInRegistries.ITEM.asLookup());
                }

                public <V> RegistryOps<V> createSerializationContext(DynamicOps<V> dynamicOps) {
                    return registryOps.withParent(dynamicOps);
                }
            });
            try {
                itemResult = parser.parse(new StringReader((String)ops.getStringValue(id).getOrThrow()));
            }
            catch (Exception e) {
                return DataResult.error(e::getMessage);
            }
            if (input.get("components") != null) {
                return DataResult.error(() -> "id with brackets cannot have the components field");
            }
            DataResult count = ExtraCodecs.POSITIVE_INT.optionalFieldOf("count", (Object)1).decode(ops, input);
            if (count.isError()) {
                return DataResult.error(() -> "Failed to decode count: " + ((DataResult.Error)count.error().orElseThrow()).message());
            }
            return DataResult.success((Object)new ItemStack(itemResult.item(), ((Integer)count.getOrThrow()).intValue(), itemResult.components()));
        }

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return ITEM_STACK_MAP_ENCODER.keys(ops);
        }
    }, () -> "MapCodec[ItemStack]");
    public static final MapCodec<ItemStack> NONEMPTY_ITEM_STACK_MAP_CODEC = ITEM_STACK_MAP_CODEC.validate(stack -> {
        if (stack.isEmpty()) {
            return DataResult.error(() -> "ItemStack cannot be empty");
        }
        return DataResult.success((Object)stack);
    });
    public static final Codec<ItemStack> ITEM_STACK = Codec.withAlternative((Codec)NONEMPTY_ITEM_STACK_MAP_CODEC.codec(), (Codec)ExtraCodecs.NON_EMPTY_STRING.flatXmap(s -> LycheeCodecs.tryCatch(() -> ParsedItem.read(new StringReader(s)).itemStack()), stack -> DataResult.error(() -> "Encoding shorthand ItemStack is not supported")));
    public static final MapCodec<BlockPos> OFFSET = RecordCodecBuilder.mapCodec(posInstance -> posInstance.group((App)Codec.INT.optionalFieldOf("offsetX", (Object)0).forGetter(Vec3i::getX), (App)Codec.INT.optionalFieldOf("offsetY", (Object)0).forGetter(Vec3i::getY), (App)Codec.INT.optionalFieldOf("offsetZ", (Object)0).forGetter(Vec3i::getZ)).apply((Applicative)posInstance, (x, y, z) -> {
        if (x == 0 && y == 0 && z == 0) {
            return BlockPos.ZERO;
        }
        return new BlockPos(x.intValue(), y.intValue(), z.intValue());
    }));
    public static final Codec<Ingredient> NONEMPTY_INGREDIENT = Codec.withAlternative((Codec)Ingredient.CODEC_NONEMPTY, (Codec)ExtraCodecs.NON_EMPTY_STRING.flatXmap(s -> LycheeCodecs.tryCatch(() -> {
        StringReader reader = new StringReader(s);
        ParsedItem parsedItem = ParsedItem.read(reader);
        Preconditions.checkArgument((!reader.canRead() ? 1 : 0) != 0, (String)"Cannot parse %s", (Object)s);
        return parsedItem.ingredient();
    }), ingredient -> DataResult.error(() -> "Encoding shorthand Ingredient is not supported")));
    public static final Codec<SizedIngredient> SIZED_INGREDIENT = Codec.withAlternative((Codec)SizedIngredient.CODEC, (Codec)ExtraCodecs.NON_EMPTY_STRING.flatXmap(s -> LycheeCodecs.tryCatch(() -> {
        StringReader reader = new StringReader(s);
        ParsedItem parsedItem = ParsedItem.read(reader);
        Preconditions.checkArgument((!reader.canRead() ? 1 : 0) != 0, (String)"Cannot parse %s", (Object)s);
        return parsedItem.sizedIngredient();
    }), ingredient -> DataResult.error(() -> "Encoding shorthand SizedIngredient is not supported")));

    public static <T, L extends List<T>> Codec<L> sizeLimit(Codec<L> listCodec, int minSize, int maxSize) {
        return listCodec.validate(list -> {
            if (list.size() < minSize) {
                return DataResult.error(() -> "List is too short: " + minSize + ", expected range [" + minSize + "-" + maxSize + "]");
            }
            if (list.size() > maxSize) {
                return DataResult.error(() -> "List is too long: " + maxSize + ", expected range [" + minSize + "-" + maxSize + "]");
            }
            return DataResult.success((Object)list);
        });
    }

    public static <T> DataResult<T> tryCatch(ThrowingSupplier<T> supplier) {
        try {
            return DataResult.success(supplier.get());
        }
        catch (Exception e) {
            return DataResult.error(e::getMessage);
        }
    }
}

