/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.codec;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import snownee.kiwi.recipe.SizedIngredient;

public record ParsedItem(ExtraCodecs.TagOrElementLocation tagOrId, int count) {
    public static ParsedItem read(StringReader input) throws CommandSyntaxException {
        return ParsedItem.read(input, false);
    }

    public static ParsedItem read(StringReader input, boolean single) throws CommandSyntaxException {
        int count = 1;
        int cursor = input.getCursor();
        try {
            count = input.readInt();
            input.expect('x');
            input.expect(' ');
            Preconditions.checkArgument((!single ? 1 : 0) != 0, (Object)"Count not allowed here");
            Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"Count must be positive");
        }
        catch (CommandSyntaxException ignored) {
            input.setCursor(cursor);
        }
        boolean tag = false;
        if (input.peek() == '#') {
            input.skip();
            tag = true;
        }
        ResourceLocation id = ResourceLocation.read((StringReader)input);
        if (!tag) {
            Preconditions.checkArgument((boolean)BuiltInRegistries.ITEM.containsKey(id), (String)"Unknown item: %s", (Object)id);
        }
        return new ParsedItem(new ExtraCodecs.TagOrElementLocation(id, tag), count);
    }

    @Override
    public String toString() {
        return this.count == 1 ? this.tagOrId.toString() : "%dx %s".formatted(this.count, this.tagOrId);
    }

    private Ingredient rawIngredient() {
        if (this.tagOrId.tag()) {
            return Ingredient.of((TagKey)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)this.tagOrId.id()));
        }
        return Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)BuiltInRegistries.ITEM.get(this.tagOrId.id())});
    }

    public Ingredient ingredient() {
        Preconditions.checkArgument((this.count == 1 ? 1 : 0) != 0, (Object)"Ingredient must not have count");
        return this.rawIngredient();
    }

    public SizedIngredient sizedIngredient() {
        return new SizedIngredient(this.rawIngredient(), this.count);
    }

    public ItemStack itemStack() {
        Preconditions.checkArgument((!this.tagOrId.tag() ? 1 : 0) != 0, (Object)"ItemStack must not be a tag");
        return new ItemStack((ItemLike)BuiltInRegistries.ITEM.getOptional(this.tagOrId.id()).orElseThrow(), this.count);
    }
}

