/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.context;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeLootContextParamSets;
import snownee.lychee.LycheeRegistries;
import snownee.lychee.context.ActionContext;
import snownee.lychee.context.AnvilContext;
import snownee.lychee.context.CraftingContext;
import snownee.lychee.context.ItemShapelessContext;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.action.ActionData;
import snownee.lychee.util.action.ActionMarker;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.input.ItemStackHolderCollection;
import snownee.lychee.util.recipe.ILycheeRecipe;

public abstract sealed class LycheeContextKey<T> {
    public static final Optional<ActionMarker> MARKER = LycheeContextKey.opt("marker", it -> {
        Level level = it.level();
        if (level.isClientSide) {
            return null;
        }
        Marker marker = new Marker(EntityType.MARKER, level);
        LootParamsContext lootParams = it.get(LOOT_PARAMS);
        Vec3 pos = (Vec3)lootParams.getOrNull(LootContextParams.ORIGIN);
        if (pos != null) {
            marker.moveTo(pos);
        }
        marker.setCustomName((Component)Component.literal((String)"lychee"));
        level.addFreshEntity((Entity)marker);
        ActionMarker actionMarker = (ActionMarker)marker;
        actionMarker.lychee$setData(new ActionData((LycheeContext)((Object)it), 0));
        return actionMarker;
    });
    public final ResourceLocation id;
    public static final Required<Level> LEVEL = LycheeContextKey.req("level");
    public static final Required<RandomSource> RANDOM = LycheeContextKey.req("random", it -> it.level().random);
    public static final Required<LootParamsContext> LOOT_PARAMS = LycheeContextKey.req("loot_params", it -> new LootParamsContext(it.level(), LycheeLootContextParamSets.ALL));
    public static final Required<ActionContext> ACTION = LycheeContextKey.req("action", it -> new ActionContext());
    public static final Optional<ResourceLocation> RECIPE_ID = LycheeContextKey.opt("recipe_id");
    public static final Optional<ILycheeRecipe<?>> RECIPE = LycheeContextKey.opt("recipe", it -> {
        Recipe patt0$temp;
        RecipeHolder<?> holder;
        ResourceLocation id = it.getOrNull(RECIPE_ID);
        if (id != null && (holder = CommonProxy.recipe(id)) != null && (patt0$temp = holder.value()) instanceof ILycheeRecipe) {
            ILycheeRecipe lycheeRecipe = (ILycheeRecipe)patt0$temp;
            return lycheeRecipe;
        }
        return null;
    });
    public static final Optional<ItemStackHolderCollection> ITEM = LycheeContextKey.opt("item", it -> ItemStackHolderCollection.empty());
    @Nullable
    public final Function<LycheeContext, T> factory;
    public static final Optional<JsonElement> JSON = LycheeContextKey.opt("data");
    public static final Optional<AnvilContext> ANVIL = LycheeContextKey.opt("anvil");
    public static final Optional<ItemShapelessContext> ITEM_SHAPELESS = LycheeContextKey.opt("item_shapeless");
    public static final Optional<CraftingContext> CRAFTING = LycheeContextKey.opt("crafting");
    public static final Optional<BlockState> DRIPSTONE_SOURCE = LycheeContextKey.opt("dripstone_root");

    protected LycheeContextKey(ResourceLocation id, @Nullable Function<LycheeContext, T> factory) {
        this.id = id;
        this.factory = factory;
    }

    public String toString() {
        return this.id.toString();
    }

    private static <T extends LycheeContextKey<?>> T register(T object) {
        Registry.register(LycheeRegistries.CONTEXT, (ResourceLocation)object.id, object);
        return object;
    }

    public static <T> Optional<T> opt(String name) {
        return LycheeContextKey.opt(name, null);
    }

    public static <T> Optional<T> opt(String name, @Nullable Function<LycheeContext, T> factory) {
        return LycheeContextKey.register(new Optional<T>(ResourceLocation.parse((String)name), factory));
    }

    public static <T> Required<T> req(String name) {
        return LycheeContextKey.req(name, null);
    }

    public static <T> Required<T> req(String name, @Nullable Function<LycheeContext, T> factory) {
        return LycheeContextKey.register(new Required<T>(ResourceLocation.parse((String)name), factory));
    }

    @Nullable
    public Codec<T> codec() {
        ResourceLocation key = LycheeRegistries.CONTEXT.getKey((Object)this);
        return (Codec)LycheeRegistries.CONTEXT_SERIALIZER.get(key);
    }

    public static final class Optional<T>
    extends LycheeContextKey<T> {
        public Optional(ResourceLocation id, @Nullable Function<LycheeContext, T> factory) {
            super(id, factory);
        }
    }

    public static final class Required<T>
    extends LycheeContextKey<T> {
        public Required(ResourceLocation id, @Nullable Function<LycheeContext, T> factory) {
            super(id, factory);
        }
    }
}

