/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.contextual;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.util.codec.KCodecs;
import snownee.lychee.Lychee;
import snownee.lychee.LycheeRegistries;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.contextual.ContextualCondition;
import snownee.lychee.util.contextual.ContextualConditionData;
import snownee.lychee.util.contextual.ContextualConditionDisplay;
import snownee.lychee.util.contextual.ContextualPredicate;
import snownee.lychee.util.recipe.ILycheeRecipe;

public class ContextualHolder
implements ContextualPredicate,
Iterable<ContextualCondition> {
    public static final Component SECRET_COMPONENT = Component.translatable((String)"contextual.lychee.secret").withStyle(ChatFormatting.GRAY);
    public static final Codec<ContextualHolder> CODEC = KCodecs.compactList((Codec)ContextualConditionData.CODEC.codec()).xmap(ContextualHolder::pack, ContextualHolder::unpack);
    public static final StreamCodec<RegistryFriendlyByteBuf, ContextualHolder> STREAM_CODEC = ContextualConditionData.STREAM_CODEC.apply(ByteBufCodecs.list()).map(ContextualHolder::pack, ContextualHolder::unpack);
    public static final ContextualHolder EMPTY = new ContextualHolder(List.of(), null, null);
    private final List<ContextualCondition> conditions;
    @Nullable
    private final BitSet secretFlags;
    @Nullable
    private final Component[] overrideDesc;

    public ContextualHolder(List<ContextualCondition> conditions, @Nullable BitSet secretFlags, @Nullable Component[] overrideDesc) {
        this.conditions = Collections.unmodifiableList(conditions);
        this.secretFlags = secretFlags;
        this.overrideDesc = overrideDesc;
    }

    public ContextualHolder(List<ContextualCondition> conditions) {
        this.conditions = conditions;
        this.secretFlags = null;
        this.overrideDesc = null;
    }

    public static ContextualHolder pack(List<ContextualConditionData> holders) {
        if (holders.isEmpty()) {
            return EMPTY;
        }
        ArrayList conditions = Lists.newArrayListWithExpectedSize((int)holders.size());
        BitSet secretFlags = null;
        Component[] overrideDesc = null;
        for (int i = 0; i < holders.size(); ++i) {
            ContextualConditionData holder = holders.get(i);
            conditions.add(holder.condition());
            if (holder.secret()) {
                if (secretFlags == null) {
                    secretFlags = new BitSet(holders.size());
                }
                secretFlags.set(i);
            }
            if (!holder.description().isPresent()) continue;
            if (overrideDesc == null) {
                overrideDesc = new Component[holders.size()];
            }
            overrideDesc[i] = holder.description().get();
        }
        return new ContextualHolder(conditions, secretFlags, overrideDesc);
    }

    public List<ContextualCondition> conditions() {
        return this.conditions;
    }

    public int showingCount() {
        return this.conditions().stream().mapToInt(ContextualConditionDisplay::showingCount).sum();
    }

    public List<ContextualConditionData> unpack() {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)this.conditions.size());
        for (int i = 0; i < this.conditions.size(); ++i) {
            ContextualCondition condition = this.conditions.get(i);
            boolean secret = this.isSecretCondition(i);
            list.add(new ContextualConditionData(condition, secret, Optional.ofNullable(this.getOverridenDesc(i))));
        }
        return list;
    }

    public void appendToTooltips(List<Component> tooltips, @Nullable Level level, @Nullable Player player, int indent) {
        if (level == null) {
            return;
        }
        int i = -1;
        for (ContextualCondition condition : this.conditions) {
            if (this.isSecretCondition(++i)) {
                TriState result = condition.testForTooltips(level, player);
                ContextualConditionDisplay.appendToTooltips(tooltips, result, indent, SECRET_COMPONENT.copy());
                continue;
            }
            Component overridenDesc = this.getOverridenDesc(i);
            if (overridenDesc != null) {
                TriState result = condition.testForTooltips(level, player);
                ContextualConditionDisplay.appendToTooltips(tooltips, result, indent, overridenDesc.copy());
                continue;
            }
            condition.appendToTooltips(tooltips, level, player, indent, false);
        }
    }

    @Override
    @NotNull
    public Iterator<ContextualCondition> iterator() {
        return this.conditions.iterator();
    }

    @Nullable
    private Component getOverridenDesc(int i) {
        if (this.overrideDesc != null) {
            return this.overrideDesc[i];
        }
        return null;
    }

    public boolean isSecretCondition(int i) {
        if (this.secretFlags != null) {
            return this.secretFlags.get(i);
        }
        return false;
    }

    @Override
    public int test(@Nullable ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        for (ContextualCondition condition : this.conditions) {
            try {
                if ((times = condition.test(recipe, ctx, times)) != 0) continue;
                break;
            }
            catch (Throwable e) {
                ResourceLocation recipeId = ctx.getOrNull(LycheeContextKey.RECIPE_ID);
                Lychee.LOGGER.error("Failed to check condition {} of recipe {}", new Object[]{LycheeRegistries.CONTEXTUAL.getKey(condition.type()), recipeId == null ? ctx.getOrNull(LycheeContextKey.RECIPE) : recipeId, e});
                return 0;
            }
        }
        return times;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextualHolder that = (ContextualHolder)o;
        return Objects.equal(this.conditions, that.conditions) && Objects.equal((Object)this.secretFlags, (Object)that.secretFlags) && Objects.equal((Object)this.overrideDesc, (Object)that.overrideDesc);
    }

    public int hashCode() {
        return this.unpack().hashCode();
    }

    public String toString() {
        return this.unpack().toString();
    }
}

