/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.json;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Reader;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import snownee.lychee.Lychee;
import snownee.lychee.util.json.JsonFragment;

public class JsonFragmentManager {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().setLenient().create();
    protected final ResourceManager resourceManager;
    protected final FileToIdConverter idConverter;
    protected final JsonFragment.Context context = new JsonFragment.Context(this::getOrLoad, Maps.newHashMap());
    private final Map<ResourceLocation, JsonElement> fragments = Maps.newHashMap();
    private final Set<JsonElement> processed = Sets.newIdentityHashSet();

    public JsonFragmentManager(ResourceManager resourceManager) {
        this(resourceManager, "lychee_fragment");
    }

    public JsonFragmentManager(ResourceManager resourceManager, String directory) {
        this.resourceManager = resourceManager;
        this.idConverter = FileToIdConverter.json((String)directory);
    }

    public void process(JsonElement json) {
        if (this.processed.contains(json)) {
            return;
        }
        try {
            this.processed.add(json);
            this.context.vars().clear();
            JsonFragment.process(json, this.context);
        }
        catch (Exception e) {
            Lychee.LOGGER.error("Failed to process fragment " + String.valueOf(json), (Throwable)e);
        }
    }

    public JsonElement getOrLoad(ResourceLocation id) {
        return this.fragments.computeIfAbsent(id, k -> {
            try {
                JsonObject fragment = (JsonObject)GSON.fromJson((Reader)this.resourceManager.getResourceOrThrow(this.idConverter.idToFile(id)).openAsReader(), JsonObject.class);
                return GsonHelper.getAsJsonObject((JsonObject)fragment, (String)"value");
            }
            catch (Exception e) {
                Lychee.LOGGER.error("Failed to load fragment " + String.valueOf(id), (Throwable)e);
                return null;
            }
        });
    }
}

