/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.json;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.util.json.JsonPointer;

public class JsonPatch {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(JsonPointer.class, (Object)new JsonPointer.Serializer()).create();
    public final Type op;
    public JsonPointer path;
    @Nullable
    public JsonPointer from;
    @Nullable
    public JsonElement value;

    public JsonPatch(Type op, JsonPointer path, @Nullable JsonPointer from, @Nullable JsonElement value) {
        this.op = op;
        this.path = path;
        this.from = from;
        this.value = value;
    }

    public static JsonPatch parse(JsonObject jsonObject) {
        try {
            JsonPatch patch = (JsonPatch)GSON.fromJson((JsonElement)jsonObject, JsonPatch.class);
            if (patch.op != null && patch.path != null) {
                return patch;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public JsonElement apply(JsonElement doc) {
        if (this.op == Type.add) {
            return JsonPatch.add(doc, this.path, this.value.deepCopy());
        }
        if (this.op == Type.remove) {
            return JsonPatch.remove(doc, this.path);
        }
        if (this.op == Type.replace) {
            return JsonPatch.replace(doc, this.path, this.value.deepCopy());
        }
        if (this.op == Type.copy) {
            return JsonPatch.copy(doc, this.path, this.from);
        }
        if (this.op == Type.move) {
            return JsonPatch.move(doc, this.path, this.from);
        }
        if (this.op == Type.test) {
            return JsonPatch.test(doc, this.path, this.value);
        }
        if (this.op == Type.merge) {
            return JsonPatch.merge(doc, this.path, this.value.deepCopy());
        }
        if (this.op == Type.deep_merge) {
            return JsonPatch.deepMerge(doc, this.path, this.value.deepCopy());
        }
        throw new IllegalArgumentException("Invalid op: " + String.valueOf((Object)this.op));
    }

    public JsonObject toJson() {
        return (JsonObject)GSON.toJsonTree((Object)this, JsonPatch.class);
    }

    public static JsonElement add(JsonElement doc, JsonPointer path, JsonElement value) {
        if (path.isRoot()) {
            return value;
        }
        JsonElement parent = path.parent().find(doc);
        Preconditions.checkNotNull((Object)parent, (Object)("Invalid path: " + String.valueOf(path)));
        String last = path.getString(-1);
        if (parent.isJsonObject()) {
            parent.getAsJsonObject().add(last, value);
        } else if (parent.isJsonArray()) {
            if ("-".equals(last)) {
                parent.getAsJsonArray().add(value);
            } else {
                JsonArray array = parent.getAsJsonArray();
                int size = array.size();
                int after = size - Integer.parseInt(last);
                array.add((JsonElement)JsonNull.INSTANCE);
                for (int i = 0; i < after; ++i) {
                    array.set(size - i, array.get(size - i - 1));
                }
                array.set(size - after, value);
            }
        } else {
            throw new IllegalArgumentException("Invalid path: " + String.valueOf(path));
        }
        return doc;
    }

    public static JsonElement remove(JsonElement doc, JsonPointer path) {
        if (path.isRoot()) {
            if (doc.isJsonObject()) {
                doc = new JsonObject();
            } else if (doc.isJsonArray()) {
                doc = new JsonArray();
            }
            return doc;
        }
        JsonElement parent = path.parent().find(doc);
        Preconditions.checkNotNull((Object)parent, (Object)("Invalid path: " + String.valueOf(path)));
        String last = path.getString(-1);
        if (parent.isJsonObject()) {
            Preconditions.checkArgument((boolean)parent.getAsJsonObject().has(last), (Object)last);
            parent.getAsJsonObject().remove(last);
        } else if (parent.isJsonArray()) {
            JsonArray array = parent.getAsJsonArray();
            if ("-".equals(last)) {
                array.remove(array.size() - 1);
            } else {
                array.remove(Integer.parseInt(last));
            }
        } else {
            throw new IllegalArgumentException("Invalid path: " + String.valueOf(path));
        }
        return doc;
    }

    public static JsonElement replace(JsonElement doc, JsonPointer path, JsonElement value) {
        doc = JsonPatch.remove(doc, path);
        return JsonPatch.add(doc, path, value);
    }

    public static JsonElement move(JsonElement doc, JsonPointer path, JsonPointer from) {
        Preconditions.checkNotNull((Object)from, (Object)"from");
        JsonElement value = from.find(doc);
        doc = JsonPatch.remove(doc, from);
        return JsonPatch.add(doc, path, value);
    }

    public static JsonElement copy(JsonElement doc, JsonPointer path, JsonPointer from) {
        Preconditions.checkNotNull((Object)from, (Object)"from");
        JsonElement value = from.find(doc);
        return JsonPatch.add(doc, path, value.deepCopy());
    }

    public static JsonElement test(JsonElement doc, JsonPointer path, JsonElement value) {
        Preconditions.checkNotNull((Object)value, (Object)"value");
        JsonElement target = path.find(doc);
        Preconditions.checkArgument((boolean)Objects.equals(value, target), (Object)("Invalid value: " + String.valueOf(target)));
        return doc;
    }

    public static JsonElement merge(JsonElement doc, JsonPointer path, JsonElement value) {
        Preconditions.checkNotNull((Object)value, (Object)"value");
        Preconditions.checkArgument((boolean)value.isJsonObject(), (Object)("Invalid value: " + String.valueOf(value)));
        JsonElement target = path.find(doc);
        Preconditions.checkArgument((target != null && target.isJsonObject() ? 1 : 0) != 0, (Object)("Invalid path: " + String.valueOf(path)));
        JsonObject targetObject = target.getAsJsonObject();
        JsonObject valueObject = value.getAsJsonObject();
        for (Map.Entry entry : valueObject.entrySet()) {
            targetObject.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        return doc;
    }

    public static JsonElement deepMerge(JsonElement doc, JsonPointer path, JsonElement value) {
        Preconditions.checkNotNull((Object)value, (Object)"value");
        JsonElement target = path.find(doc);
        Preconditions.checkNotNull((Object)target, (Object)("Invalid path: " + String.valueOf(path)));
        ArrayDeque<String> tokens = new ArrayDeque<String>(path.tokens);
        JsonPatch.deepMergeInternal(tokens, target, value);
        return doc;
    }

    private static JsonElement deepMergeInternal(ArrayDeque<String> tokens, JsonElement target, JsonElement value) {
        block6: {
            block5: {
                if (target.getClass() != value.getClass()) {
                    return value;
                }
                if (!target.isJsonObject()) break block5;
                JsonObject targetObject = target.getAsJsonObject();
                JsonObject valueObject = value.getAsJsonObject();
                for (Map.Entry entry : valueObject.entrySet()) {
                    String key = (String)entry.getKey();
                    if (targetObject.has(key)) {
                        tokens.addLast(key);
                        targetObject.add(key, JsonPatch.deepMergeInternal(tokens, targetObject.get(key), (JsonElement)entry.getValue()));
                        tokens.removeLast();
                        continue;
                    }
                    targetObject.add(key, (JsonElement)entry.getValue());
                }
                break block6;
            }
            if (!target.isJsonArray()) break block6;
            JsonArray targetArray = target.getAsJsonArray();
            JsonArray valueArray = value.getAsJsonArray();
            int size = targetArray.size();
            for (int i = 0; i < size; ++i) {
                if (i < valueArray.size()) {
                    tokens.addLast(String.valueOf(i));
                    targetArray.set(i, JsonPatch.deepMergeInternal(tokens, targetArray.get(i), valueArray.get(i)));
                    tokens.removeLast();
                    continue;
                }
                valueArray.add(targetArray.get(i));
            }
        }
        return value;
    }

    public static enum Type {
        add,
        remove,
        replace,
        copy,
        move,
        test,
        merge,
        deep_merge;

    }
}

