/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import snownee.lychee.util.BoundsExtensions;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.codec.AliasOptionalFieldCodec;
import snownee.lychee.util.codec.LycheeStreamCodecs;
import snownee.lychee.util.contextual.ContextualHolder;

public record LycheeRecipeCommonProperties(boolean hideInRecipeViewer, boolean ghost, Optional<String> comment, String group, ContextualHolder conditions, List<PostAction> postActions, MinMaxBounds.Ints maxRepeats) {
    public static final MapCodec<Boolean> HIDE_IN_VIEWER_CODEC = Codec.BOOL.optionalFieldOf("hide_in_viewer", (Object)false);
    public static final MapCodec<Boolean> GHOST_CODEC = Codec.BOOL.optionalFieldOf("ghost", (Object)false);
    public static final MapCodec<Optional<String>> COMMENT_CODEC = Codec.STRING.optionalFieldOf("comment");
    public static final MapCodec<String> GROUP_CODEC = Codec.STRING.validate(s -> {
        if (ResourceLocation.tryParse((String)s) == null) {
            return DataResult.error(() -> "Invalid group: " + s + " (must be a valid resource location)");
        }
        return DataResult.success((Object)s);
    }).optionalFieldOf("group", (Object)"default");
    public static final MapCodec<ContextualHolder> CONTEXTUAL_CODEC = AliasOptionalFieldCodec.defaulted("if", ContextualHolder.CODEC, ContextualHolder.EMPTY, "contextual");
    public static final MapCodec<List<PostAction>> POST_ACTION_CODEC = PostAction.LIST_CODEC.optionalFieldOf("post", List.of());
    public static final MapCodec<LycheeRecipeCommonProperties> SIMPLE_MAP_CODEC = LycheeRecipeCommonProperties.mapCodec(MinMaxBounds.Ints.ANY);
    public static final StreamCodec<RegistryFriendlyByteBuf, LycheeRecipeCommonProperties> STREAM_CODEC = LycheeStreamCodecs.composite(ByteBufCodecs.BOOL, LycheeRecipeCommonProperties::hideInRecipeViewer, ByteBufCodecs.BOOL, LycheeRecipeCommonProperties::ghost, ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), LycheeRecipeCommonProperties::comment, ByteBufCodecs.STRING_UTF8, LycheeRecipeCommonProperties::group, ContextualHolder.STREAM_CODEC, LycheeRecipeCommonProperties::conditions, PostAction.STREAM_LIST_CODEC, LycheeRecipeCommonProperties::postActions, ByteBufCodecs.fromCodec((Codec)MinMaxBounds.Ints.CODEC), LycheeRecipeCommonProperties::maxRepeats, LycheeRecipeCommonProperties::new);

    public static MapCodec<LycheeRecipeCommonProperties> mapCodec(MinMaxBounds.Ints defaultMaxRepeats) {
        return RecordCodecBuilder.mapCodec((T instance) -> instance.group((App)HIDE_IN_VIEWER_CODEC.forGetter(LycheeRecipeCommonProperties::hideInRecipeViewer), (App)GHOST_CODEC.forGetter(LycheeRecipeCommonProperties::ghost), (App)COMMENT_CODEC.forGetter(LycheeRecipeCommonProperties::comment), (App)GROUP_CODEC.forGetter(LycheeRecipeCommonProperties::group), (App)CONTEXTUAL_CODEC.forGetter(LycheeRecipeCommonProperties::conditions), (App)POST_ACTION_CODEC.forGetter(LycheeRecipeCommonProperties::postActions), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("max_repeats", (Object)defaultMaxRepeats).forGetter(LycheeRecipeCommonProperties::maxRepeats)).apply((Applicative)instance, LycheeRecipeCommonProperties::of));
    }

    private static LycheeRecipeCommonProperties of(boolean hideInRecipeViewer, boolean ghost, Optional<String> comment, String group, ContextualHolder conditions, List<PostAction> postActions, MinMaxBounds.Ints maxRepeats) {
        if (postActions.stream().anyMatch(it -> !it.repeatable())) {
            maxRepeats = BoundsExtensions.ONE;
        }
        return new LycheeRecipeCommonProperties(hideInRecipeViewer, ghost, comment, group, conditions, postActions, maxRepeats);
    }
}

