/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.ui;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.Level;
import snownee.kiwi.recipe.EmptyRecipeInput;
import snownee.kiwi.recipe.SimpleRecipe;
import snownee.kiwi.util.codec.KCodecs;
import snownee.lychee.util.Patterns;
import snownee.lychee.util.ui.UIElement;

public abstract class CategorySettingRecipe
extends SimpleRecipe<EmptyRecipeInput>
implements Comparable<CategorySettingRecipe> {
    public static final Codec<Map<String, List<UIElement>>> ELEMENTS_CODEC = ExtraCodecs.strictUnboundedMap((Codec)ExtraCodecs.NON_EMPTY_STRING, (Codec)KCodecs.compactList(UIElement.CODEC));
    public static final StreamCodec<RegistryFriendlyByteBuf, Optional<Map<String, List<UIElement>>>> ELEMENTS_STREAM_CODEC = ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.map(HashMap::newHashMap, (StreamCodec)ByteBufCodecs.STRING_UTF8, (StreamCodec)UIElement.STREAM_CODEC.apply(ByteBufCodecs.list())));
    private final int sortOrder;
    private final Patterns category;
    private final Optional<Map<String, List<UIElement>>> elements;
    private final boolean renderDefault;

    public CategorySettingRecipe() {
        this.sortOrder = 0;
        this.category = Patterns.EMPTY;
        this.elements = Optional.empty();
        this.renderDefault = true;
    }

    public CategorySettingRecipe(int sortOrder, Patterns category, Optional<Map<String, List<UIElement>>> elements, boolean renderDefault) {
        this.sortOrder = sortOrder;
        this.category = category;
        this.elements = elements;
        this.renderDefault = renderDefault;
    }

    public boolean matches(EmptyRecipeInput input, Level level) {
        return false;
    }

    public int sortOrder() {
        return this.sortOrder;
    }

    public Patterns category() {
        return this.category;
    }

    public Optional<Map<String, List<UIElement>>> elements() {
        return this.elements;
    }

    public boolean renderDefault() {
        return this.renderDefault;
    }

    @Override
    public int compareTo(CategorySettingRecipe o) {
        return Integer.compare(this.sortOrder, o.sortOrder);
    }
}

