/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.ui;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.client.gui.InteractiveRenderElement;
import snownee.lychee.util.ClientProxy;

public interface InputAction {
    public static MousePressed mousePressed(int button, double mouseX, double mouseY) {
        return new MousePressed(button, mouseX, mouseY);
    }

    public static InputAction mousePressed(int button) {
        MouseHandler mouseHandler = Minecraft.getInstance().mouseHandler;
        Window window = Minecraft.getInstance().getWindow();
        double mouseX = mouseHandler.xpos() * (double)window.getGuiScaledWidth() / (double)window.getScreenWidth();
        double mouseY = mouseHandler.ypos() * (double)window.getGuiScaledHeight() / (double)window.getScreenHeight();
        return InputAction.mousePressed(button, mouseX, mouseY);
    }

    default public InputConstants.Key keyMapping() {
        return ClientProxy.getKeyMapping(this);
    }

    default public boolean isMouseOver(@Nullable InteractiveRenderElement element) {
        return true;
    }

    public static KeyPressed keyPressed(int keyCode, int scanCode, int modifiers) {
        return new KeyPressed(keyCode, scanCode, modifiers);
    }

    public static class MousePressed
    implements InputAction {
        public final int button;
        public final double mouseX;
        public final double mouseY;

        public MousePressed(int button, double mouseX, double mouseY) {
            this.button = button;
            this.mouseX = mouseX;
            this.mouseY = mouseY;
        }
    }

    public static class KeyPressed
    implements InputAction {
        public final int keyCode;
        public final int scanCode;
        public final int modifiers;

        public KeyPressed(int keyCode, int scanCode, int modifiers) {
            this.keyCode = keyCode;
            this.scanCode = scanCode;
            this.modifiers = modifiers;
        }

        @Override
        public boolean isMouseOver(@Nullable InteractiveRenderElement element) {
            return element != null && element.isHovered();
        }
    }

    public record Direct(String name) implements InputAction
    {
        public static final Direct SHOW_RECIPES = new Direct("show_recipes");
        public static final Direct SHOW_USAGES = new Direct("show_usages");
        public static final Direct FAVORITE = new Direct("favorite");
    }
}

