/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public abstract class ItemStackToItemStackRecipe
extends MekanismRecipe<SingleRecipeInput>
implements Predicate<ItemStack> {
    protected final RecipeType<ItemStackToItemStackRecipe> recipeType;

    public ItemStackToItemStackRecipe(RecipeType<ItemStackToItemStackRecipe> recipeType) {
        this.recipeType = Objects.requireNonNull(recipeType, "Recipe type cannot be null");
    }

    @Override
    public abstract boolean test(ItemStack var1);

    @Override
    @NotNull
    public ItemStack assemble(SingleRecipeInput input, HolderLookup.Provider provider) {
        if (!this.isIncomplete() && this.test(input.item())) {
            return this.getOutput(input.item());
        }
        return ItemStack.EMPTY;
    }

    public boolean matches(SingleRecipeInput input, Level level) {
        return !this.isIncomplete() && this.test(input.item());
    }

    public abstract ItemStackIngredient getInput();

    @Contract(value="_ -> new", pure=true)
    public abstract ItemStack getOutput(ItemStack var1);

    @Override
    @NotNull
    public abstract ItemStack getResultItem(@NotNull HolderLookup.Provider var1);

    public abstract List<ItemStack> getOutputDefinition();

    @Override
    public boolean isIncomplete() {
        return this.getInput().hasNoMatchingInstances();
    }

    @Override
    public void logMissingTags() {
        this.getInput().logMissingTags();
    }

    public final RecipeType<ItemStackToItemStackRecipe> getType() {
        return this.recipeType;
    }
}

