/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.graph;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GuiGraph<COLLECTION extends Collection<?>, HANDLER extends GraphDataHandler>
extends GuiTexturedElement {
    private static final int TEXTURE_WIDTH = 3;
    private static final int TEXTURE_HEIGHT = 2;
    protected final COLLECTION graphData;
    protected final HANDLER dataHandler;
    @Nullable
    private Component lastInfo = null;
    @Nullable
    private Tooltip lastTooltip;
    @Nullable
    private ScreenRectangle cachedTooltipRect;
    protected boolean fixedScale = false;

    protected GuiGraph(IGuiWrapper gui, int x, int y, int width, int height, COLLECTION graphData, HANDLER handler) {
        super(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "graph.png"), gui, x, y, width, height);
        this.graphData = graphData;
        this.dataHandler = handler;
    }

    @Override
    public void drawBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderBackgroundTexture(guiGraphics, GuiInnerScreen.SCREEN, GuiInnerScreen.SCREEN_SIZE, GuiInnerScreen.SCREEN_SIZE);
        ResourceLocation texture = this.getResource();
        int size = this.graphData.size();
        int x = this.relativeX + 1;
        int y = this.relativeY + 1;
        int height = this.height - 2;
        for (int i = 0; i < size; ++i) {
            int relativeHeight = this.getRelativeHeight(i, height);
            guiGraphics.blit(texture, x + i, y + height - relativeHeight, 0.0f, 0.0f, 1, 1, 3, 2);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 0.2f + 0.8f * (float)i / (float)size);
            guiGraphics.blit(texture, x + i, y + height - relativeHeight, 1.0f, 0.0f, 1, relativeHeight, 3, 2);
            int hoverIndex = mouseX - this.getX();
            if (hoverIndex == i && mouseY >= this.getY() && mouseY < this.getY() + height) {
                guiGraphics.setColor(1.0f, 1.0f, 1.0f, 0.5f);
                guiGraphics.blit(texture, x + i, y, 2.0f, 0.0f, 1, height, 3, 2);
                MekanismRenderer.resetColor(guiGraphics);
                guiGraphics.blit(texture, x + i, y + height - relativeHeight, 0.0f, 1.0f, 1, 1, 3, 2);
            } else {
                MekanismRenderer.resetColor(guiGraphics);
            }
            RenderSystem.disableBlend();
        }
    }

    protected abstract int getRelativeHeight(int var1, int var2);

    protected abstract Component getDataDisplay(int var1);

    @Override
    @NotNull
    protected ScreenRectangle getTooltipRectangle(int mouseX, int mouseY) {
        return this.cachedTooltipRect == null ? super.getTooltipRectangle(mouseX, mouseY) : this.cachedTooltipRect;
    }

    @Override
    public void updateTooltip(int mouseX, int mouseY) {
        int hoverIndex = mouseX - this.getX();
        if (hoverIndex >= 0 && hoverIndex < this.graphData.size()) {
            Component info = this.getDataDisplay(hoverIndex);
            if (!info.equals((Object)this.lastInfo)) {
                this.lastInfo = info;
                this.lastTooltip = TooltipUtils.create(info);
            }
            this.cachedTooltipRect = new ScreenRectangle(this.getX(), this.getGuiTop() + this.getButtonY(), 1, this.getButtonHeight());
        } else {
            this.lastInfo = null;
            this.lastTooltip = null;
            this.cachedTooltipRect = null;
        }
        this.setTooltip(this.lastTooltip);
    }

    public static interface GraphDataHandler {
    }
}

