/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import mekanism.client.model.ModelPartData;
import mekanism.client.render.RenderTickHandler;
import mekanism.client.render.lib.Outlines;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;

public abstract class MekanismJavaModel
extends Model {
    public MekanismJavaModel(Function<ResourceLocation, RenderType> renderType) {
        super(renderType);
    }

    protected static VertexConsumer getVertexConsumer(@NotNull MultiBufferSource renderer, @NotNull RenderType renderType, boolean hasEffect) {
        return ItemRenderer.getFoilBufferDirect((MultiBufferSource)renderer, (RenderType)renderType, (boolean)false, (boolean)hasEffect);
    }

    protected static void setRotation(ModelPart model, float x, float y, float z) {
        model.xRot = x;
        model.yRot = y;
        model.zRot = z;
    }

    protected static void renderPartsToBuffer(List<ModelPart> parts, PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int light, int overlayLight, int argb) {
        for (ModelPart part : parts) {
            part.render(poseStack, vertexConsumer, light, overlayLight, argb);
        }
    }

    protected static List<ModelPart> getRenderableParts(ModelPart root, ModelPartData ... modelPartData) {
        ArrayList<ModelPart> parts = new ArrayList<ModelPart>(modelPartData.length);
        for (ModelPartData partData : modelPartData) {
            parts.add(partData.getFromRoot(root));
        }
        return parts;
    }

    protected static LayerDefinition createLayerDefinition(int textureWidth, int textureHeight, ModelPartData ... parts) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        for (ModelPartData part : parts) {
            part.addToDefinition(partdefinition);
        }
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)textureWidth, (int)textureHeight);
    }

    protected static void renderPartsAsWireFrame(List<ModelPart> parts, PoseStack poseStack, @NotNull VertexConsumer vertexConsumer) {
        Vector4f pos = new Vector4f();
        Vector3f normal = new Vector3f();
        Vector3f v0 = new Vector3f();
        Vector3f v1 = new Vector3f();
        Vector3f v2 = new Vector3f();
        Vector3f v3 = new Vector3f();
        for (ModelPart part : parts) {
            MekanismJavaModel.visit(part, poseStack, vertexConsumer, pos, normal, v0, v1, v2, v3);
        }
    }

    private static void visit(ModelPart part, PoseStack poseStack, VertexConsumer vertexConsumer, Vector4f pos, Vector3f normal, Vector3f v0, Vector3f v1, Vector3f v2, Vector3f v3) {
        if (!(!part.visible || part.isEmpty() && part.children.isEmpty())) {
            poseStack.pushPose();
            part.translateAndRotate(poseStack);
            MekanismJavaModel.visitAndRender(part.cubes, poseStack, vertexConsumer, pos, normal, v0, v1, v2, v3);
            for (ModelPart child : part.children.values()) {
                MekanismJavaModel.visit(child, poseStack, vertexConsumer, pos, normal, v0, v1, v2, v3);
            }
            poseStack.popPose();
        }
    }

    private static void visitAndRender(List<ModelPart.Cube> cubes, PoseStack matrix, VertexConsumer buffer, Vector4f pos, Vector3f normal, Vector3f v0, Vector3f v1, Vector3f v2, Vector3f v3) {
        Matrix4f pose = matrix.last().pose();
        Matrix3f poseNormal = matrix.last().normal();
        HashSet<Outlines.Line> lines = new HashSet<Outlines.Line>();
        for (ModelPart.Cube cube : cubes) {
            for (ModelPart.Polygon quad : cube.polygons) {
                quad.vertices[0].pos.div(16.0f, v0);
                quad.vertices[1].pos.div(16.0f, v1);
                quad.vertices[2].pos.div(16.0f, v2);
                quad.vertices[3].pos.div(16.0f, v3);
                lines.add(Outlines.Line.from(v0, v1));
                lines.add(Outlines.Line.from(v1, v2));
                lines.add(Outlines.Line.from(v2, v3));
                lines.add(Outlines.Line.from(v3, v0));
            }
        }
        RenderTickHandler.renderVertexWireFrame(lines, buffer, pose, poseNormal, pos, normal);
    }
}

