/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.emi.recipe;

import dev.emi.emi.api.widget.WidgetHolder;
import mekanism.api.recipes.ItemStackToEnergyRecipe;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiEnergyGauge;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.recipe_viewer.RecipeViewerUtils;
import mekanism.client.recipe_viewer.emi.MekanismEmiRecipeCategory;
import mekanism.client.recipe_viewer.emi.recipe.MekanismEmiHolderRecipe;
import mekanism.common.tile.component.config.DataType;
import net.minecraft.world.item.crafting.RecipeHolder;

public class ItemStackToEnergyEmiRecipe
extends MekanismEmiHolderRecipe<ItemStackToEnergyRecipe> {
    public ItemStackToEnergyEmiRecipe(MekanismEmiRecipeCategory category, RecipeHolder<ItemStackToEnergyRecipe> recipeHolder) {
        super(category, recipeHolder);
        this.addInputDefinition(((ItemStackToEnergyRecipe)this.recipe).getInput());
    }

    public void addWidgets(WidgetHolder widgetHolder) {
        GuiEnergyGauge.IEnergyInfoHandler energyInfoHandler = this.getEnergyInfoHandler();
        this.addElement(widgetHolder, new GuiEnergyGauge(energyInfoHandler, GaugeType.STANDARD.with(DataType.OUTPUT), (IGuiWrapper)this, 133, 13));
        this.addSlot(widgetHolder, SlotType.INPUT, 26, 36, this.input(0));
        this.addConstantProgress(widgetHolder, ProgressType.LARGE_RIGHT, 64, 40);
    }

    private GuiEnergyGauge.IEnergyInfoHandler getEnergyInfoHandler() {
        final long[] outputDefinition = ((ItemStackToEnergyRecipe)this.recipe).getOutputDefinition();
        if (outputDefinition.length > 1) {
            long maxEnergy = 0L;
            for (long val : outputDefinition) {
                maxEnergy = Math.max(maxEnergy, val);
            }
            final long finalMaxEnergy = maxEnergy;
            return new GuiEnergyGauge.IEnergyInfoHandler(){

                @Override
                public long getEnergy() {
                    return RecipeViewerUtils.getCurrent(outputDefinition);
                }

                @Override
                public long getMaxEnergy() {
                    return finalMaxEnergy;
                }
            };
        }
        final long energy = outputDefinition.length == 0 ? 0L : outputDefinition[0];
        return new GuiEnergyGauge.IEnergyInfoHandler(){

            @Override
            public long getEnergy() {
                return energy;
            }

            @Override
            public long getMaxEnergy() {
                return energy;
            }
        };
    }
}

