/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.text.EnumColor;
import mekanism.common.util.EnumUtils;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public record AttachedEjector(List<Optional<EnumColor>> inputColors, boolean strictInput, Optional<EnumColor> outputColor) {
    public static final AttachedEjector DEFAULT = new AttachedEjector(Arrays.stream(EnumUtils.SIDES).map(side -> Optional.empty()).toList(), false, Optional.empty());
    public static final Codec<AttachedEjector> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.optionalEmptyMap(EnumColor.CODEC).listOf(EnumUtils.SIDES.length, EnumUtils.SIDES.length).fieldOf("input_color").forGetter(AttachedEjector::inputColors), (App)Codec.BOOL.fieldOf("strict_input").forGetter(AttachedEjector::strictInput), (App)EnumColor.CODEC.optionalFieldOf("types").forGetter(AttachedEjector::outputColor)).apply((Applicative)instance, AttachedEjector::new));
    public static final StreamCodec<ByteBuf, AttachedEjector> STREAM_CODEC = StreamCodec.composite((StreamCodec)EnumColor.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list((int)EnumUtils.SIDES.length)), AttachedEjector::inputColors, (StreamCodec)ByteBufCodecs.BOOL, AttachedEjector::strictInput, EnumColor.OPTIONAL_STREAM_CODEC, AttachedEjector::outputColor, AttachedEjector::new);

    public AttachedEjector {
        if (inputColors.size() != EnumUtils.SIDES.length) {
            throw new IllegalArgumentException("Expected there to be an input color for each side");
        }
        inputColors = Collections.unmodifiableList(inputColors);
    }

    public static AttachedEjector create(EnumColor[] inputColors, boolean strictInput, @Nullable EnumColor outputColor) {
        boolean isDefault = strictInput == DEFAULT.strictInput() && outputColor == DEFAULT.outputColor().orElse(null);
        ArrayList<Optional<EnumColor>> inputs = new ArrayList<Optional<EnumColor>>(inputColors.length);
        for (EnumColor inputColor : inputColors) {
            inputs.add(Optional.ofNullable(inputColor));
            if (inputColor == null) continue;
            isDefault = false;
        }
        if (isDefault) {
            return DEFAULT;
        }
        return new AttachedEjector(inputs, strictInput, Optional.ofNullable(outputColor));
    }
}

