/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekatool;

import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleContainer;
import mekanism.api.gear.ModuleData;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.gear.ItemMekaTool;
import mekanism.common.registries.MekanismModules;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.IShearable;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNotNullByDefault
public class ModuleShearingUnit
implements ICustomModule<ModuleShearingUnit> {
    private static final Predicate<Entity> SHEARABLE = entity -> !entity.isSpectator() && entity instanceof IShearable;

    @Override
    public boolean canPerformAction(IModule<ModuleShearingUnit> module, IModuleContainer container, ItemStack stack, ItemAbility action) {
        if (action == ItemAbilities.SHEARS_DISARM) {
            if (stack.getItem() instanceof ItemMekaTool) {
                long cost = ItemMekaTool.getDestroyEnergy(container, 0.0f, container.hasEnabled((Holder<ModuleData<?>>)MekanismModules.SILK_TOUCH_UNIT));
                return module.hasEnoughEnergy(stack, cost);
            }
            return true;
        }
        if (action == ItemAbilities.SHEARS_DIG) {
            return !(stack.getItem() instanceof ItemMekaTool) || ItemMekaTool.hasEnergyForDigAction(container, module.getEnergyContainer(stack));
        }
        if (action == ItemAbilities.SHEARS_TRIM) {
            return module.hasEnoughEnergy(stack, MekanismConfig.gear.mekaToolEnergyUsageShearTrim);
        }
        return ItemAbilities.DEFAULT_SHEARS_ACTIONS.contains(action);
    }

    @Override
    @NotNull
    public InteractionResult onInteract(IModule<ModuleShearingUnit> module, Player player, LivingEntity entity, InteractionHand hand, IModuleContainer moduleContainer, ItemStack stack) {
        if (entity instanceof IShearable) {
            long cost = MekanismConfig.gear.mekaToolEnergyUsageShearEntity.get();
            IEnergyContainer energyContainer = module.getEnergyContainer(stack);
            if (cost == 0L || energyContainer != null && energyContainer.getEnergy() >= cost && this.shearEntity(energyContainer, entity, player, stack, entity.level(), entity.blockPosition())) {
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    @NotNull
    public InteractionResult onItemUse(IModule<ModuleShearingUnit> module, UseOnContext context) {
        BlockPos blockpos;
        Level level;
        BlockState state;
        BlockState trimmedState;
        long cost = MekanismConfig.gear.mekaToolEnergyUsageShearTrim.get();
        ItemStack stack = context.getItemInHand();
        IEnergyContainer energyContainer = module.getEnergyContainer(stack);
        if ((cost == 0L || energyContainer != null && energyContainer.getEnergy() >= cost) && (trimmedState = (state = (level = context.getLevel()).getBlockState(blockpos = context.getClickedPos())).getToolModifiedState(context, ItemAbilities.SHEARS_TRIM, false)) != null) {
            Player player = context.getPlayer();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(player2, blockpos, stack);
            }
            level.setBlockAndUpdate(blockpos, trimmedState);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockpos, GameEvent.Context.of((Entity)context.getPlayer(), (BlockState)trimmedState));
            if (cost > 0L) {
                energyContainer.extract(cost, Action.EXECUTE, AutomationType.MANUAL);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    @Override
    @NotNull
    public ICustomModule.ModuleDispenseResult onDispense(IModule<ModuleShearingUnit> module, IModuleContainer moduleContainer, ItemStack stack, BlockSource source) {
        ServerLevel world = source.level();
        Direction facing = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
        BlockPos pos = source.pos().relative(facing);
        if (CommonHooks.tryDispenseShearsHarvestBlock((BlockSource)source, (ItemStack)stack, (ServerLevel)world, (BlockPos)pos) || this.tryShearLivingEntity(module.getEnergyContainer(stack), world, pos, stack)) {
            return ICustomModule.ModuleDispenseResult.HANDLED;
        }
        return ICustomModule.ModuleDispenseResult.FAIL_PREVENT_DROP;
    }

    private boolean tryShearLivingEntity(@Nullable IEnergyContainer energyContainer, ServerLevel world, BlockPos pos, ItemStack stack) {
        long cost = MekanismConfig.gear.mekaToolEnergyUsageShearEntity.get();
        if (cost == 0L || energyContainer != null && energyContainer.getEnergy() >= MekanismConfig.gear.mekaToolEnergyUsageShearEntity.get()) {
            for (LivingEntity entity : world.getEntitiesOfClass(LivingEntity.class, new AABB(pos), SHEARABLE)) {
                if (!this.shearEntity(energyContainer, entity, null, stack, (Level)world, pos)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean shearEntity(@Nullable IEnergyContainer energyContainer, LivingEntity entity, @Nullable Player player, ItemStack stack, Level world, BlockPos pos) {
        IShearable target = (IShearable)entity;
        if (target.isShearable(player, stack, world, pos)) {
            if (!world.isClientSide) {
                for (ItemStack drop : target.onSheared(player, stack, world, pos)) {
                    target.spawnShearedDrop(world, pos, drop);
                }
                entity.gameEvent((Holder)GameEvent.SHEAR, (Entity)player);
                if (energyContainer != null) {
                    energyContainer.extract(MekanismConfig.gear.mekaToolEnergyUsageShearEntity.get(), Action.EXECUTE, AutomationType.MANUAL);
                }
            }
            return true;
        }
        return false;
    }
}

